/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.script.ScriptException;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.PSystemUtils;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.anim.Animation;
import net.sourceforge.plantuml.anim.AnimationDecoder;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.UnparsableGraphvizException;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.fun.IconLoader;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.QuoteUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import net.sourceforge.plantuml.pdf.PdfConverter;
import net.sourceforge.plantuml.svek.EmptySvgException;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.Sprite;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UmlDiagram
extends AbstractPSystem
implements Diagram {
    private boolean rotation;
    private boolean hideUnlinkedData;
    private int minwidth = Integer.MAX_VALUE;
    private Display title = Display.NULL;
    private Display header = Display.NULL;
    private Display footer = Display.NULL;
    private Display legend = Display.NULL;
    private HorizontalAlignment legendAlignment = HorizontalAlignment.CENTER;
    private VerticalAlignment legendVerticalAlignment = VerticalAlignment.BOTTOM;
    private HorizontalAlignment headerAlignment = HorizontalAlignment.RIGHT;
    private HorizontalAlignment footerAlignment = HorizontalAlignment.CENTER;
    private final Pragma pragma = new Pragma();
    private Scale scale;
    private Animation animation;
    private final SkinParam skinParam = new SkinParam();
    private Dimension2D lastInfo;

    public final void setTitle(Display display) {
        this.title = display;
    }

    @Override
    public final Display getTitle() {
        return this.title;
    }

    public final int getMinwidth() {
        return this.minwidth;
    }

    public final void setMinwidth(int n) {
        this.minwidth = n;
    }

    public final boolean isRotation() {
        return this.rotation;
    }

    public final void setRotation(boolean bl) {
        this.rotation = bl;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public void setParam(String string, String string2) {
        this.skinParam.setParam(StringUtils.goLowerCase(string), string2);
    }

    public final Display getHeader() {
        return this.header;
    }

    public final void setHeader(Display display) {
        this.header = display;
    }

    public final Display getFooter() {
        return this.footer;
    }

    public final void setFooter(Display display) {
        this.footer = display;
    }

    public final HorizontalAlignment getHeaderAlignment() {
        return this.headerAlignment;
    }

    public final void setHeaderAlignment(HorizontalAlignment horizontalAlignment) {
        this.headerAlignment = horizontalAlignment;
    }

    public final HorizontalAlignment getFooterAlignment() {
        return this.footerAlignment;
    }

    public final HorizontalAlignment getAlignmentTeoz(FontParam fontParam) {
        if (fontParam == FontParam.FOOTER) {
            return this.getFooterAlignment();
        }
        if (fontParam == FontParam.HEADER) {
            return this.getHeaderAlignment();
        }
        throw new IllegalArgumentException();
    }

    public final Display getFooterOrHeaderTeoz(FontParam fontParam) {
        if (fontParam == FontParam.FOOTER) {
            return this.getFooter();
        }
        if (fontParam == FontParam.HEADER) {
            return this.getHeader();
        }
        throw new IllegalArgumentException();
    }

    public final void setFooterAlignment(HorizontalAlignment horizontalAlignment) {
        this.footerAlignment = horizontalAlignment;
    }

    public abstract UmlDiagramType getUmlDiagramType();

    public Pragma getPragma() {
        return this.pragma;
    }

    public final void setScale(Scale scale) {
        this.scale = scale;
    }

    public final Scale getScale() {
        return this.scale;
    }

    public final void setAnimation(Iterable<CharSequence> iterable) {
        try {
            AnimationDecoder animationDecoder = new AnimationDecoder(iterable);
            this.animation = Animation.create(animationDecoder.decode());
        }
        catch (ScriptException scriptException) {
            scriptException.printStackTrace();
        }
    }

    public final Animation getAnimation() {
        return this.animation;
    }

    public final double getDpiFactor(FileFormatOption fileFormatOption) {
        if (this.getSkinParam().getDpi() == 96) {
            return 1.0;
        }
        return (double)this.getSkinParam().getDpi() / 96.0;
    }

    public final int getDpi(FileFormatOption fileFormatOption) {
        return this.getSkinParam().getDpi();
    }

    public final boolean isHideUnlinkedData() {
        return this.hideUnlinkedData;
    }

    public final void setHideUnlinkedData(boolean bl) {
        this.hideUnlinkedData = bl;
    }

    @Override
    public final ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        if (fileFormatOption.getFileFormat() == FileFormat.PDF) {
            return this.exportDiagramInternalPdf(outputStream, n);
        }
        try {
            ImageData imageData = this.exportDiagramInternal(outputStream, n, fileFormatOption);
            this.lastInfo = new Dimension2DDouble(imageData.getWidth(), imageData.getHeight());
            return imageData;
        }
        catch (UnparsableGraphvizException unparsableGraphvizException) {
            unparsableGraphvizException.printStackTrace();
            this.exportDiagramError(outputStream, unparsableGraphvizException.getCause(), fileFormatOption, unparsableGraphvizException.getGraphvizVersion());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.exportDiagramError(outputStream, exception, fileFormatOption, null);
        }
        return new ImageDataSimple();
    }

    private void exportDiagramError(OutputStream outputStream, Throwable throwable, FileFormatOption fileFormatOption, String string) throws IOException {
        UmlDiagram.exportDiagramError2(outputStream, throwable, fileFormatOption, this.getMetadata(), this.getFlashData(), UmlDiagram.getFailureText1(throwable, string));
    }

    public static void exportDiagramError2(OutputStream outputStream, Throwable throwable, FileFormatOption fileFormatOption, String string, String string2, List<String> list) throws IOException {
        UFont uFont = new UFont("SansSerif", 0, 12);
        list.addAll(CommandExecutionResult.getStackTrace(throwable));
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, string, null, 0.0, 0.0, null, false);
        FlashCodeUtils flashCodeUtils = FlashCodeFactory.getFlashCodeUtils();
        final BufferedImage bufferedImage = flashCodeUtils.exportFlashcode(string2);
        if (bufferedImage != null) {
            GraphvizCrash.addDecodeHint(list);
        }
        final GraphicStrings graphicStrings = new GraphicStrings(list, uFont, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON, IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
        if (bufferedImage == null) {
            imageBuilder.addUDrawable(graphicStrings);
        } else {
            imageBuilder.addUDrawable(new UDrawable(){

                public void drawU(UGraphic uGraphic) {
                    graphicStrings.drawU(uGraphic);
                    double d = graphicStrings.calculateDimension(uGraphic.getStringBounder()).getHeight();
                    uGraphic = uGraphic.apply(new UTranslate(0.0, d));
                    uGraphic.draw(new UImage(bufferedImage));
                }
            });
        }
        imageBuilder.writeImageTOBEMOVED(fileFormatOption, outputStream);
    }

    private String getFlashData() {
        StringBuilder stringBuilder = new StringBuilder();
        UmlSource umlSource = this.getSource();
        stringBuilder.append(umlSource.getPlainString());
        return stringBuilder.toString();
    }

    private static List<String> getFailureText1(Throwable throwable, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("An error has occured : " + throwable);
        String string2 = QuoteUtils.getSomeQuote();
        arrayList.add("<i>" + string2);
        arrayList.add(" ");
        arrayList.add("PlantUML (" + Version.versionString() + ") cannot parse result from dot/GraphViz.");
        if (throwable instanceof EmptySvgException) {
            arrayList.add("Because dot/GraphViz returns an empty string.");
        }
        if (string != null) {
            arrayList.add(" ");
            arrayList.add("GraphViz version used : " + string);
        }
        arrayList.add(" ");
        GraphvizCrash.addProperties(arrayList);
        arrayList.add(" ");
        arrayList.add("This may be caused by :");
        arrayList.add(" - a bug in PlantUML");
        arrayList.add(" - a problem in GraphViz");
        arrayList.add(" ");
        arrayList.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> to solve this issue.");
        arrayList.add("You can try to turn arround this issue by simplifing your diagram.");
        arrayList.add(" ");
        return arrayList;
    }

    public static List<String> getFailureText2(Throwable throwable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("An error has occured : " + throwable);
        String string = QuoteUtils.getSomeQuote();
        arrayList.add("<i>" + string);
        arrayList.add(" ");
        arrayList.add("PlantUML (" + Version.versionString() + ") has crashed.");
        arrayList.add(" ");
        arrayList.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> to solve this issue.");
        arrayList.add("You can try to turn arround this issue by simplifing your diagram.");
        arrayList.add(" ");
        return arrayList;
    }

    private void exportDiagramInternalMjpeg(OutputStream outputStream) throws IOException {
        File file = new File("c:/test.avi");
        MJPEGGenerator mJPEGGenerator = new MJPEGGenerator(file, 640, 480, 30.0, 150);
        for (int i = 0; i < 150; ++i) {
            AffineTransform affineTransform = new AffineTransform();
            double d = (double)(149 - i) * 1.0 / 150.0;
            affineTransform.setToShear(d, d);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.close();
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            mJPEGGenerator.addImage(bufferedImage);
        }
        mJPEGGenerator.finishAVI();
    }

    private ImageData exportDiagramInternalPdf(OutputStream outputStream, int n) throws IOException {
        File file = FileUtils.createTempFile("pdf", ".svf");
        File file2 = FileUtils.createTempFile("pdf", ".pdf");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ImageData imageData = this.exportDiagram(bufferedOutputStream, n, new FileFormatOption(FileFormat.SVG));
        ((OutputStream)bufferedOutputStream).close();
        PdfConverter.convert(file, file2);
        FileUtils.copyToStream(file2, outputStream);
        return imageData;
    }

    protected abstract ImageData exportDiagramInternal(OutputStream var1, int var2, FileFormatOption var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void exportCmap(File file, ImageData imageData) throws FileNotFoundException {
        String string = UmlDiagram.changeName(file.getAbsolutePath());
        File file2 = new File(string);
        PrintWriter printWriter = null;
        try {
            if (!PSystemUtils.canFileBeWritten(file2)) {
                return;
            }
            printWriter = new PrintWriter(file2);
            printWriter.print(imageData.getCMapData(file2.getName().substring(0, file2.getName().length() - 6)));
            printWriter.close();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    static String changeName(String string) {
        return string.replaceAll("(?i)\\.\\w{3}$", ".cmapx");
    }

    @Override
    public String getWarningOrError() {
        if (this.lastInfo == null) {
            return null;
        }
        double d = this.lastInfo.getWidth();
        if (d == 0.0) {
            return null;
        }
        String string = this.getSkinParam().getValue("widthwarning");
        if (string == null) {
            return null;
        }
        if (!string.matches("\\d+")) {
            return null;
        }
        int n = Integer.parseInt(string);
        if (d > (double)n) {
            return "The image is " + (int)d + " pixel width. (Warning limit is " + n + ")";
        }
        return null;
    }

    public void addSprite(String string, Sprite sprite) {
        this.skinParam.addSprite(string, sprite);
    }

    public final Display getLegend() {
        return this.legend;
    }

    public final HorizontalAlignment getLegendAlignment() {
        return this.legendAlignment;
    }

    public final VerticalAlignment getLegendVerticalAlignment() {
        return this.legendVerticalAlignment;
    }

    public final void setLegend(Display display, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this.legend = display;
        this.legendAlignment = horizontalAlignment;
        this.legendVerticalAlignment = verticalAlignment;
    }
}

