/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.MonoSwimable;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

public class InstructionSimple
extends MonoSwimable
implements Instruction {
    private boolean killed = false;
    private final Display label;
    private final Colors colors;
    private final LinkRendering inlinkRendering;
    private Display note;
    private NotePosition notePosition;
    private final BoxStyle style;
    private final Url url;

    public InstructionSimple(Display display, LinkRendering linkRendering, Swimlane swimlane, BoxStyle boxStyle, Url url, Colors colors) {
        super(swimlane);
        if (colors == null) {
            throw new IllegalArgumentException();
        }
        this.url = url;
        this.style = boxStyle;
        this.label = display;
        this.inlinkRendering = linkRendering;
        this.colors = colors;
    }

    public Ftile createFtile(FtileFactory ftileFactory) {
        Ftile ftile = ftileFactory.activity(this.label, this.getSwimlaneIn(), this.style, this.colors);
        if (this.url != null) {
            ftile = ftileFactory.addUrl(ftile, this.url);
        }
        if (this.note != null) {
            ftile = ftileFactory.addNote(ftile, this.note, this.notePosition);
        }
        if (this.killed) {
            return new FtileKilled(ftile);
        }
        return ftile;
    }

    public void add(Instruction instruction) {
        throw new UnsupportedOperationException();
    }

    public final boolean kill() {
        this.killed = true;
        return true;
    }

    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    public boolean addNote(Display display, NotePosition notePosition) {
        this.note = display;
        this.notePosition = notePosition;
        return true;
    }
}

