/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.HtmlColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandArrowLong3
extends CommandMultilines2<ActivityDiagram3> {
    public CommandArrowLong3() {
        super(CommandArrowLong3.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "^(.*);$";
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOr(new RegexLeaf("->"), new RegexLeaf("COLOR", "-\\[(#\\w+)\\]->")), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public CommandExecutionResult executeNow(ActivityDiagram3 activityDiagram3, BlocLines blocLines) {
        blocLines = blocLines.removeEmptyColumns();
        RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
        HtmlColor htmlColor = activityDiagram3.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0));
        activityDiagram3.setColorNextArrow(htmlColor);
        blocLines = blocLines.removeStartingAndEnding2(regexResult.get("LABEL", 0));
        activityDiagram3.setLabelNextArrow(blocLines.toDisplay());
        return CommandExecutionResult.ok();
    }

    private <CS extends CharSequence> void removeStarting(List<CS> list, String string) {
        if (list.size() == 0) {
            return;
        }
        list.set(0, string);
    }

    private <CS extends CharSequence> void removeEnding(List<CS> list) {
        if (list.size() == 0) {
            return;
        }
        int n = list.size() - 1;
        CharSequence charSequence = (CharSequence)list.get(n);
        list.set(n, charSequence.subSequence(0, charSequence.length() - 1));
    }
}

