/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandPartition3
extends SingleLineCommand2<ActivityDiagram3> {
    public CommandPartition3() {
        super(CommandPartition3.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("partition"), new RegexLeaf("[%s]+"), new RegexLeaf("BACKCOLOR", "(?:(#\\w+)[%s]+)?"), new RegexLeaf("TITLECOLOR", "(?:(#\\w+)[%s]+)?"), new RegexLeaf("NAME", "([%g][^%g]+[%g]|\\S+)"), new RegexLeaf("[%s]*\\{?$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 activityDiagram3, RegexResult regexResult) {
        String string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("NAME", 0));
        HtmlColor htmlColor = activityDiagram3.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("TITLECOLOR", 0));
        HtmlColor htmlColor2 = activityDiagram3.getSkinParam().getHtmlColor(ColorParam.partitionBackground, null, false);
        HtmlColor htmlColor3 = htmlColor2 == null ? activityDiagram3.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("BACKCOLOR", 0)) : htmlColor2;
        HtmlColor htmlColor4 = activityDiagram3.getSkinParam().getHtmlColor(ColorParam.partitionBorder, null, false);
        if (htmlColor4 == null) {
            htmlColor4 = HtmlColorUtils.BLACK;
        }
        activityDiagram3.startGroup(Display.getWithNewlines(string), htmlColor3, htmlColor, htmlColor4);
        return CommandExecutionResult.ok();
    }
}

