/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDecorate;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileMinWidth
extends FtileDecorate {
    private final double minWidth;
    private FtileGeometry calculateDimensionInternal;

    public FtileMinWidth(Ftile ftile, double d) {
        super(ftile);
        this.minWidth = d;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        UTranslate uTranslate = this.getUTranslateInternal(stringBounder);
        super.drawU(uGraphic.apply(uTranslate));
    }

    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        if (this.calculateDimensionInternal == null) {
            this.calculateDimensionInternal = this.calculateDimensionSlow(stringBounder);
        }
        return this.calculateDimensionInternal;
    }

    private FtileGeometry calculateDimensionSlow(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = super.calculateDimension(stringBounder);
        double d = this.getPoint2(ftileGeometry.getLeft(), stringBounder);
        if (!ftileGeometry.hasPointOut()) {
            return new FtileGeometry(this.getDimensionInternal(stringBounder), d, ftileGeometry.getInY());
        }
        return new FtileGeometry(this.getDimensionInternal(stringBounder), d, ftileGeometry.getInY(), ftileGeometry.getOutY());
    }

    private Dimension2D getDimensionInternal(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.getFtileDelegated().calculateDimension(stringBounder);
        if (((Dimension2D)ftileGeometry).getWidth() < this.minWidth) {
            return new Dimension2DDouble(this.minWidth, ((Dimension2D)ftileGeometry).getHeight());
        }
        return ftileGeometry;
    }

    private UTranslate getUTranslateInternal(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.getFtileDelegated().calculateDimension(stringBounder);
        Dimension2D dimension2D = this.getDimensionInternal(stringBounder);
        UTranslate uTranslate = new UTranslate((dimension2D.getWidth() - ((Dimension2D)ftileGeometry).getWidth()) / 2.0, 0.0);
        return uTranslate;
    }

    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.getFtileDelegated()) {
            return this.getUTranslateInternal(stringBounder);
        }
        return null;
    }

    private double getPoint2(double d, StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.getFtileDelegated().calculateDimension(stringBounder);
        if (((Dimension2D)ftileGeometry).getWidth() < this.minWidth) {
            double d2 = this.minWidth - ((Dimension2D)ftileGeometry).getWidth();
            return d + d2 / 2.0;
        }
        return d;
    }
}

