/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileOverpassing;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithLinks;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside3;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileIfLongVertical
extends AbstractFtile {
    private final double ySeparation = 20.0;
    private final double marginy1 = 30.0;
    private final List<Ftile> tiles;
    private final Ftile tile2;
    private final List<Ftile> diamonds;
    private final Ftile lastDiamond;
    private final HtmlColor arrowColor;

    private FtileIfLongVertical(List<Ftile> list, List<Ftile> list2, Ftile ftile, HtmlColor htmlColor, Ftile ftile2) {
        super(list2.get(0).shadowing() || ftile.shadowing());
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException();
        }
        this.lastDiamond = ftile2;
        this.tile2 = ftile;
        this.diamonds = new ArrayList<Ftile>(list);
        this.tiles = new ArrayList<Ftile>(list2);
        this.arrowColor = htmlColor;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            hashSet.add(this.getSwimlaneIn());
        }
        for (Ftile ftile : this.tiles) {
            hashSet.addAll(ftile.getSwimlanes());
        }
        hashSet.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tiles.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Swimlane swimlane, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, FtileFactory ftileFactory, ConditionStyle conditionStyle, List<Branch> list, Branch branch, FontConfiguration fontConfiguration, LinkRendering linkRendering, LinkRendering linkRendering2) {
        int htmlColor5;
        Object object;
        TextBlock textBlock;
        TextBlock textBlock2;
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>();
        for (Branch object22 : list) {
            arrayList.add(new FtileMinWidth(object22.getFtile(), 30.0));
        }
        FtileMinWidth ftileMinWidth = new FtileMinWidth(branch.getFtile(), 30.0);
        ArrayList<Ftile> arrayList2 = new ArrayList<Ftile>();
        for (Branch n2 : list) {
            textBlock2 = n2.getLabelPositive().create(fontConfiguration, HorizontalAlignment.LEFT, ftileFactory);
            textBlock = n2.getLabelTest().create(fontConfiguration, HorizontalAlignment.LEFT, ftileFactory);
            object = new FtileDiamondInside3(n2.shadowing(), htmlColor2, htmlColor, swimlane, textBlock);
            object = ((FtileDiamondInside3)object).withEast(textBlock2);
            arrayList2.add((Ftile)object);
        }
        TextBlock textBlock3 = branch.getLabelPositive().create(fontConfiguration, HorizontalAlignment.LEFT, ftileFactory);
        int n = arrayList2.size() - 1;
        arrayList2.set(n, ((FtileDiamondInside3)arrayList2.get(n)).withSouth(textBlock3));
        textBlock2 = new FtileDiamond(((Ftile)arrayList.get(0)).shadowing(), htmlColor2, htmlColor, swimlane);
        textBlock = new FtileIfLongVertical(arrayList2, arrayList, ftileMinWidth, htmlColor3, (Ftile)textBlock2);
        object = new ArrayList();
        for (htmlColor5 = 0; htmlColor5 < list.size(); ++htmlColor5) {
            Ftile ftile = (Ftile)arrayList.get(htmlColor5);
            Ftile ftile2 = (Ftile)arrayList2.get(htmlColor5);
            HtmlColor htmlColor4 = FtileIfWithLinks.getInColor(list.get(htmlColor5), htmlColor3);
            TextBlock textBlock4 = textBlock;
            textBlock4.getClass();
            object.add((FtileIfLongVertical)textBlock4.new ConnectionVerticalIn(ftile2, ftile, htmlColor4 == null ? htmlColor3 : htmlColor4));
        }
        for (htmlColor5 = 0; htmlColor5 < arrayList2.size() - 1; ++htmlColor5) {
            TextBlock textBlock5 = textBlock;
            textBlock5.getClass();
            object.add((FtileIfLongVertical)textBlock5.new ConnectionVertical((Ftile)arrayList2.get(htmlColor5), (Ftile)arrayList2.get(htmlColor5 + 1), htmlColor3));
        }
        TextBlock textBlock6 = textBlock;
        textBlock6.getClass();
        object.add((FtileIfLongVertical)textBlock6.new ConnectionThenOut((Ftile)arrayList.get(0), htmlColor3));
        for (htmlColor5 = 1; htmlColor5 < arrayList.size(); ++htmlColor5) {
            TextBlock textBlock7 = textBlock;
            textBlock7.getClass();
            object.add((FtileIfLongVertical)textBlock7.new ConnectionThenOutConnect((Ftile)arrayList.get(htmlColor5), htmlColor3));
        }
        HtmlColor htmlColor6 = LinkRendering.getColor(linkRendering, htmlColor3);
        TextBlock textBlock8 = textBlock;
        textBlock8.getClass();
        object.add((FtileIfLongVertical)textBlock8.new ConnectionIn(htmlColor6));
        TextBlock textBlock9 = textBlock;
        textBlock9.getClass();
        object.add((FtileIfLongVertical)textBlock9.new ConnectionLastElse(htmlColor6));
        TextBlock textBlock10 = textBlock;
        textBlock10.getClass();
        object.add((FtileIfLongVertical)textBlock10.new ConnectionLastElseOut(htmlColor3));
        return FtileUtils.addConnection((Ftile)textBlock, (Collection<Connection>)object);
    }

    private static double getYdiamontOutToLeft(FtileGeometry ftileGeometry, StringBounder stringBounder) {
        return (ftileGeometry.getInY() + ftileGeometry.getOutY()) / 2.0;
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.tile2) {
            return this.getTranslate2(stringBounder);
        }
        if (ftile == this.lastDiamond) {
            return this.getTranslateLastDiamond(stringBounder);
        }
        if (this.tiles.contains(ftile)) {
            return this.getTranslate1(ftile, stringBounder);
        }
        if (this.diamonds.contains(ftile)) {
            return this.getTranslateDiamond(ftile, stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslateDiamond(Ftile ftile, StringBounder stringBounder) {
        double d = this.allDiamondsWidth(stringBounder);
        int n = this.diamonds.indexOf(ftile);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        double d2 = this.getTranslateDy(n, stringBounder);
        return new UTranslate((d - ftile.calculateDimension(stringBounder).getWidth()) / 2.0, d2);
    }

    private UTranslate getTranslateLastDiamond(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry2 = this.lastDiamond.calculateDimension(stringBounder);
        double d = (((Dimension2D)ftileGeometry).getWidth() - ftileGeometry2.getWidth()) / 2.0;
        return new UTranslate(d, ((Dimension2D)ftileGeometry).getHeight() - ftileGeometry2.getHeight());
    }

    private UTranslate getTranslate1(Ftile ftile, StringBounder stringBounder) {
        int n = this.tiles.indexOf(ftile);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        double d = this.getTranslateDy(n, stringBounder);
        FtileGeometry ftileGeometry = this.diamonds.get(n).calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = ftile.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry3 = this.calculateDimensionInternal(stringBounder);
        double d2 = this.allDiamondsWidth(stringBounder);
        double d3 = d2 + (ftileGeometry3.getWidth() - d2 - ftileGeometry2.getWidth()) / 2.0;
        return new UTranslate(d3, d + ftileGeometry.getHeight());
    }

    private double getTranslateDy(int n, StringBounder stringBounder) {
        double d = 30.0;
        for (int i = 0; i < n; ++i) {
            FtileGeometry ftileGeometry = this.tiles.get(i).calculateDimension(stringBounder);
            FtileGeometry ftileGeometry2 = this.diamonds.get(i).calculateDimension(stringBounder);
            d += ftileGeometry.getHeight() + ftileGeometry2.getHeight() + 20.0;
        }
        return d;
    }

    private UTranslate getTranslate2(StringBounder stringBounder) {
        double d = this.getTranslateDy(this.tiles.size(), stringBounder);
        FtileGeometry ftileGeometry = this.tile2.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.calculateDimensionInternal(stringBounder);
        double d2 = (ftileGeometry2.getWidth() - ftileGeometry.getWidth()) / 2.0;
        return new UTranslate(d2, d);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        for (Ftile ftile : this.tiles) {
            uGraphic.apply(this.getTranslate1(ftile, stringBounder)).draw(ftile);
        }
        for (Ftile ftile : this.diamonds) {
            uGraphic.apply(this.getTranslateDiamond(ftile, stringBounder)).draw(ftile);
        }
        uGraphic.apply(this.getTranslate2(stringBounder)).draw(this.tile2);
        uGraphic.apply(this.getTranslateLastDiamond(stringBounder)).draw(this.lastDiamond);
    }

    private FtileGeometry calculateDimensionInternal(StringBounder stringBounder) {
        FtileGeometry ftileGeometry;
        FtileGeometry ftileGeometry2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 30.0;
        for (int i = 0; i < this.tiles.size(); ++i) {
            FtileGeometry ftileGeometry3 = this.tiles.get(i).calculateDimension(stringBounder);
            ftileGeometry2 = ((FtileOverpassing)this.diamonds.get(i)).getOverpassDimension(stringBounder);
            ftileGeometry = this.diamonds.get(i).calculateDimension(stringBounder);
            d4 += ftileGeometry.getHeight() + ftileGeometry3.getHeight();
            d = Math.max(d, ftileGeometry.getWidth());
            d2 = Math.max(d2, ftileGeometry2.getWidth());
            d3 = Math.max(d3, ftileGeometry3.getWidth());
        }
        double d5 = Math.max(d + d3, d2);
        ftileGeometry2 = new FtileGeometry(d5, d4, d5 / 2.0, 0.0);
        ftileGeometry = this.tile2.calculateDimension(stringBounder);
        ftileGeometry2 = ftileGeometry2.appendBottom(ftileGeometry);
        FtileGeometry ftileGeometry4 = this.lastDiamond.calculateDimension(stringBounder);
        ftileGeometry2 = ftileGeometry2.addDim(0.0, 20.0 * (double)this.tiles.size() + 40.0 + ftileGeometry4.getHeight());
        return new FtileGeometry(ftileGeometry2, ftileGeometry2.getWidth() / 2.0, 0.0);
    }

    private double allDiamondsWidth(StringBounder stringBounder) {
        double d = 0.0;
        for (Ftile ftile : this.diamonds) {
            d = Math.max(d, ftile.calculateDimension(stringBounder).getWidth());
        }
        return d;
    }

    private double allTile1Width(StringBounder stringBounder) {
        double d = 0.0;
        for (Ftile ftile : this.tiles) {
            d = Math.max(d, ftile.calculateDimension(stringBounder).getWidth());
        }
        return d;
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimensionInternal(stringBounder);
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>(this.tiles);
        arrayList.add(this.tile2);
        for (Ftile ftile : arrayList) {
            if (!ftile.calculateDimension(stringBounder).hasPointOut()) continue;
            return new FtileGeometry(ftileGeometry, ((Dimension2D)ftileGeometry).getWidth() / 2.0, 0.0, ((Dimension2D)ftileGeometry).getHeight());
        }
        return new FtileGeometry(ftileGeometry, ((Dimension2D)ftileGeometry).getWidth() / 2.0, 0.0);
    }

    class ConnectionThenOutConnect
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionThenOutConnect(Ftile ftile, HtmlColor htmlColor) {
            super(ftile, FtileIfLongVertical.this.lastDiamond);
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D point2D = FtileIfLongVertical.this.getTranslate1(this.getFtile1(), stringBounder).getTranslated(ftileGeometry.getPointOut());
            FtileGeometry ftileGeometry2 = FtileIfLongVertical.this.calculateDimensionInternal(stringBounder);
            Point2D.Double double_ = new Point2D.Double(((Dimension2D)ftileGeometry2).getWidth(), point2D.getY() + 15.0);
            Snake snake = new Snake(this.arrowColor, Arrows.asToRight());
            snake.addPoint(point2D);
            snake.addPoint(point2D.getX(), ((Point2D)double_).getY());
            snake.addPoint(double_);
            uGraphic.draw(snake);
        }
    }

    class ConnectionThenOut
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionThenOut(Ftile ftile, HtmlColor htmlColor) {
            super(ftile, FtileIfLongVertical.this.lastDiamond);
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D point2D = FtileIfLongVertical.this.getTranslate1(this.getFtile1(), stringBounder).getTranslated(ftileGeometry.getPointOut());
            FtileGeometry ftileGeometry2 = this.getFtile2().calculateDimension(stringBounder);
            Point2D point2D2 = FtileIfLongVertical.this.getTranslateLastDiamond(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
            point2D2 = new UTranslate(ftileGeometry2.getWidth() / 2.0, ftileGeometry2.getHeight() / 2.0).getTranslated(point2D2);
            FtileGeometry ftileGeometry3 = FtileIfLongVertical.this.calculateDimensionInternal(stringBounder);
            Snake snake = new Snake(this.arrowColor, Arrows.asToLeft());
            snake.addPoint(point2D);
            snake.addPoint(point2D.getX(), point2D.getY() + 15.0);
            snake.addPoint(((Dimension2D)ftileGeometry3).getWidth(), point2D.getY() + 15.0);
            snake.addPoint(((Dimension2D)ftileGeometry3).getWidth(), point2D2.getY());
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }
    }

    class ConnectionLastElseOut
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionLastElseOut(HtmlColor htmlColor) {
            super(FtileIfLongVertical.this.tile2, FtileIfLongVertical.this.lastDiamond);
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D point2D = FtileIfLongVertical.this.getTranslate2(stringBounder).getTranslated(ftileGeometry.getPointOut());
            Point2D point2D2 = FtileIfLongVertical.this.getTranslateLastDiamond(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(point2D.getX(), point2D2.getY() - 15.0);
            snake.addPoint(point2D2.getX(), point2D2.getY() - 15.0);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }
    }

    class ConnectionLastElse
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionLastElse(HtmlColor htmlColor) {
            super((Ftile)FtileIfLongVertical.this.diamonds.get(FtileIfLongVertical.this.diamonds.size() - 1), FtileIfLongVertical.this.tile2);
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            UTranslate uTranslate = FtileIfLongVertical.this.getTranslateDiamond(this.getFtile1(), stringBounder);
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            Point2D point2D = uTranslate.getTranslated(ftileGeometry.getPointOut());
            Point2D point2D2 = FtileIfLongVertical.this.getTranslate2(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(point2D.getX(), point2D2.getY() - 15.0);
            snake.addPoint(point2D2.getX(), point2D2.getY() - 15.0);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }
    }

    class ConnectionVertical
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionVertical(Ftile ftile, Ftile ftile2, HtmlColor htmlColor) {
            super(ftile, ftile2);
            this.color = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.color, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            Point2D point2D = this.getFtile1().calculateDimension(stringBounder).getPointOut();
            return FtileIfLongVertical.this.getTranslateFor(this.getFtile1(), stringBounder).getTranslated(point2D);
        }

        private Point2D getP2(StringBounder stringBounder) {
            Point2D point2D = this.getFtile2().calculateDimension(stringBounder).getPointIn();
            return FtileIfLongVertical.this.getTranslateFor(this.getFtile2(), stringBounder).getTranslated(point2D);
        }
    }

    class ConnectionVerticalIn
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionVerticalIn(Ftile ftile, Ftile ftile2, HtmlColor htmlColor) {
            super(ftile, ftile2);
            this.color = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.color, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(point2D2.getX(), point2D.getY());
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            double d = ((Dimension2D)ftileGeometry).getWidth();
            return FtileIfLongVertical.this.getTranslateDiamond(this.getFtile1(), stringBounder).getTranslated(new Point2D.Double(d, ((Dimension2D)ftileGeometry).getHeight() / 2.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            Point2D point2D = this.getFtile2().calculateDimension(stringBounder).getPointIn();
            return FtileIfLongVertical.this.getTranslate1(this.getFtile2(), stringBounder).getTranslated(point2D);
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionIn(HtmlColor htmlColor) {
            super(null, (Ftile)FtileIfLongVertical.this.diamonds.get(0));
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            UTranslate uTranslate = FtileIfLongVertical.this.getTranslateDiamond(this.getFtile2(), uGraphic.getStringBounder());
            Point2D point2D = uTranslate.getTranslated(this.getFtile2().calculateDimension(uGraphic.getStringBounder()).getPointIn());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Point2D point2D2 = FtileIfLongVertical.this.calculateDimensionInternal(uGraphic.getStringBounder()).getPointIn();
            snake.addPoint(point2D2);
            snake.addPoint(point2D2.getX(), (point2D2.getY() + point2D.getY()) / 2.0);
            snake.addPoint(point2D.getX(), (point2D2.getY() + point2D.getY()) / 2.0);
            snake.addPoint(point2D);
            uGraphic.draw(snake);
        }
    }
}

