/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfNude;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithDiamonds;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithLinks;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class ConditionalBuilder {
    private final Swimlane swimlane;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final HtmlColor arrowColor;
    private final FtileFactory ftileFactory;
    private final ConditionStyle conditionStyle;
    private final Branch branch1;
    private final Branch branch2;
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;
    private final FontConfiguration fontArrow;
    private final FontConfiguration fontTest;
    private final Ftile tile1;
    private final Ftile tile2;

    public ConditionalBuilder(Swimlane swimlane, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, FtileFactory ftileFactory, ConditionStyle conditionStyle, Branch branch, Branch branch2, ISkinParam iSkinParam, StringBounder stringBounder, FontConfiguration fontConfiguration, FontConfiguration fontConfiguration2) {
        this.swimlane = swimlane;
        this.borderColor = htmlColor;
        this.backColor = htmlColor2;
        this.arrowColor = htmlColor3;
        this.ftileFactory = ftileFactory;
        this.conditionStyle = conditionStyle;
        this.branch1 = branch;
        this.branch2 = branch2;
        this.skinParam = iSkinParam;
        this.stringBounder = stringBounder;
        this.fontArrow = fontConfiguration;
        this.fontTest = fontConfiguration2;
        this.tile1 = new FtileMinWidth(branch.getFtile(), 30.0);
        this.tile2 = new FtileMinWidth(branch2.getFtile(), 30.0);
    }

    public static Ftile create(Swimlane swimlane, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, FtileFactory ftileFactory, ConditionStyle conditionStyle, Branch branch, Branch branch2, ISkinParam iSkinParam, StringBounder stringBounder, FontConfiguration fontConfiguration, FontConfiguration fontConfiguration2) {
        ConditionalBuilder conditionalBuilder = new ConditionalBuilder(swimlane, htmlColor, htmlColor2, htmlColor3, ftileFactory, conditionStyle, branch, branch2, iSkinParam, stringBounder, fontConfiguration, fontConfiguration2);
        return conditionalBuilder.createWithLinks();
    }

    private Ftile createNude() {
        return new FtileIfNude(this.tile1, this.tile2, this.swimlane);
    }

    private Ftile createWithDiamonds() {
        Ftile ftile = this.getDiamond1();
        Ftile ftile2 = this.getDiamond2();
        FtileIfWithDiamonds ftileIfWithDiamonds = new FtileIfWithDiamonds(ftile, this.tile1, this.tile2, ftile2, this.swimlane, this.stringBounder);
        Dimension2D dimension2D = this.getLabelBranch1().calculateDimension(this.stringBounder);
        Dimension2D dimension2D2 = this.getLabelBranch2().calculateDimension(this.stringBounder);
        double d = ftileIfWithDiamonds.computeMarginNeedForBranchLabe1(this.stringBounder, dimension2D);
        double d2 = ftileIfWithDiamonds.computeMarginNeedForBranchLabe2(this.stringBounder, dimension2D2);
        Ftile ftile3 = FtileUtils.addHorizontalMargin(ftileIfWithDiamonds, d, d2);
        double d3 = ftileIfWithDiamonds.computeVerticalMarginNeedForBranchs(this.stringBounder, dimension2D, dimension2D2);
        ftile3 = FtileUtils.addVerticalMargin(ftile3, d3, 0.0);
        return ftile3;
    }

    private Ftile createWithLinks() {
        Ftile ftile = this.getDiamond1();
        Ftile ftile2 = this.getDiamond2();
        Ftile ftile3 = FtileUtils.addHorizontalMargin(this.tile1, 10.0);
        Ftile ftile4 = FtileUtils.addHorizontalMargin(this.tile2, 10.0);
        FtileIfWithLinks ftileIfWithLinks = new FtileIfWithLinks(ftile, ftile3, ftile4, ftile2, this.swimlane, this.arrowColor, this.stringBounder);
        Dimension2D dimension2D = this.getLabelBranch1().calculateDimension(this.stringBounder);
        Dimension2D dimension2D2 = this.getLabelBranch2().calculateDimension(this.stringBounder);
        double d = ftileIfWithLinks.computeMarginNeedForBranchLabe1(this.stringBounder, dimension2D);
        double d2 = ftileIfWithLinks.computeMarginNeedForBranchLabe2(this.stringBounder, dimension2D2);
        double d3 = ftileIfWithLinks.computeVerticalMarginNeedForBranchs(this.stringBounder, dimension2D, dimension2D2);
        Ftile ftile5 = ftileIfWithLinks.addLinks(this.branch1, this.branch2, this.stringBounder);
        ftile5 = FtileUtils.addHorizontalMargin(ftile5, d, d2);
        ftile5 = FtileUtils.addVerticalMargin(ftile5, d3, 0.0);
        return ftile5;
    }

    private Ftile getDiamond1() {
        Ftile ftile;
        Display display = this.branch1.getLabelTest();
        TextBlock textBlock = this.getLabelBranch1();
        TextBlock textBlock2 = this.getLabelBranch2();
        Sheet sheet = new CreoleParser(this.fontTest, HorizontalAlignment.LEFT, this.skinParam, CreoleMode.FULL).createSheet(display);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, 0.0, this.skinParam.getPadding());
        SheetBlock2 sheetBlock2 = new SheetBlock2(sheetBlock1, Diamond.asStencil(sheetBlock1), new UStroke(1.5));
        if (this.conditionStyle == ConditionStyle.INSIDE) {
            ftile = new FtileDiamondInside(this.tile1.shadowing(), this.backColor, this.borderColor, this.swimlane, sheetBlock2).withWestAndEast(textBlock, textBlock2);
        } else if (this.conditionStyle == ConditionStyle.DIAMOND) {
            ftile = new FtileDiamond(this.tile1.shadowing(), this.backColor, this.borderColor, this.swimlane).withNorth(sheetBlock2).withWestAndEast(textBlock, textBlock2);
        } else {
            throw new IllegalStateException();
        }
        return ftile;
    }

    private TextBlock getLabelBranch2() {
        TextBlock textBlock = this.branch2.getLabelPositive().create(this.fontArrow, HorizontalAlignment.LEFT, this.ftileFactory, CreoleMode.SIMPLE_LINE);
        return textBlock;
    }

    private TextBlock getLabelBranch1() {
        TextBlock textBlock = this.branch1.getLabelPositive().create(this.fontArrow, HorizontalAlignment.LEFT, this.ftileFactory, CreoleMode.SIMPLE_LINE);
        return textBlock;
    }

    private Ftile getDiamond2() {
        AbstractFtile abstractFtile;
        if (this.hasTwoBranches()) {
            Display display = LinkRendering.getDisplay(this.branch1.getFtile().getOutLinkRendering());
            TextBlock textBlock = display == null ? null : display.create(this.fontArrow, HorizontalAlignment.LEFT, this.ftileFactory, CreoleMode.SIMPLE_LINE);
            Display display2 = LinkRendering.getDisplay(this.branch2.getFtile().getOutLinkRendering());
            TextBlock textBlock2 = display2 == null ? null : display2.create(this.fontArrow, HorizontalAlignment.LEFT, this.ftileFactory, CreoleMode.SIMPLE_LINE);
            abstractFtile = new FtileDiamond(this.tile1.shadowing(), this.backColor, this.borderColor, this.swimlane).withWest(textBlock).withEast(textBlock2);
        } else {
            abstractFtile = new FtileEmpty(this.tile1.shadowing(), 0.0, 6.0, this.swimlane, this.swimlane);
        }
        return abstractFtile;
    }

    public boolean hasTwoBranches() {
        return this.tile1.calculateDimension(this.stringBounder).hasPointOut() && this.tile2.calculateDimension(this.stringBounder).hasPointOut();
    }
}

