/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileDimensionMemoize;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileIfNude
extends FtileDimensionMemoize {
    protected final Ftile tile1;
    protected final Ftile tile2;
    private final Swimlane in;

    FtileIfNude(Ftile ftile, Ftile ftile2, Swimlane swimlane) {
        super(ftile.shadowing() || ftile2.shadowing());
        this.tile1 = ftile;
        this.tile2 = ftile2;
        this.in = swimlane;
    }

    public boolean hasTwoBranches(StringBounder stringBounder) {
        return this.tile1.calculateDimension(stringBounder).hasPointOut() && this.tile2.calculateDimension(stringBounder).hasPointOut();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            hashSet.add(this.getSwimlaneIn());
        }
        hashSet.addAll(this.tile1.getSwimlanes());
        hashSet.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.in;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    protected UTranslate getTranslate1(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry2 = this.tile1.calculateDimension(stringBounder);
        return new UTranslate(0.0, 0.0);
    }

    protected UTranslate getTranslate2(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry2 = this.tile2.calculateDimension(stringBounder);
        double d = ((Dimension2D)ftileGeometry).getWidth() - ((Dimension2D)ftileGeometry2).getWidth();
        return new UTranslate(d, 0.0);
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.tile1) {
            return this.getTranslate1(stringBounder);
        }
        if (ftile == this.tile2) {
            return this.getTranslate2(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.apply(this.getTranslate1(stringBounder)).draw(this.tile1);
        uGraphic.apply(this.getTranslate2(stringBounder)).draw(this.tile2);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimensionInternal(stringBounder);
        if (this.tile1.calculateDimension(stringBounder).hasPointOut() || this.tile2.calculateDimension(stringBounder).hasPointOut()) {
            return ftileGeometry;
        }
        return ftileGeometry.withoutPointOut();
    }

    @Override
    protected FtileGeometry calculateDimensionInternalSlow(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.tile1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.tile2.calculateDimension(stringBounder);
        double d = this.withInner(stringBounder);
        double d2 = ftileGeometry.getLeft() + d + (ftileGeometry2.getWidth() - ftileGeometry2.getLeft());
        Dimension2D dimension2D = Dimension2DDouble.mergeLR(ftileGeometry, ftileGeometry2);
        return new FtileGeometry(d2, dimension2D.getHeight(), ftileGeometry.getLeft() + d / 2.0, 0.0);
    }

    protected double withInner(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.tile1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.tile2.calculateDimension(stringBounder);
        return ftileGeometry.getWidth() - ftileGeometry.getLeft() + ftileGeometry2.getLeft();
    }
}

