/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.regex.Matcher;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandMultilinesFooter
extends CommandMultilines<UmlDiagram> {
    public CommandMultilinesFooter() {
        super("(?i)^(?:(left|right|center)?[%s]*)footer$");
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?footer$";
    }

    @Override
    public CommandExecutionResult execute(UmlDiagram umlDiagram, BlocLines blocLines) {
        Display display;
        blocLines = blocLines.trim(false);
        Matcher matcher = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        String string = matcher.group(1);
        if (string != null) {
            umlDiagram.setFooterAlignment(HorizontalAlignment.valueOf(StringUtils.goUpperCase(string)));
        }
        if ((display = (blocLines = blocLines.subExtract(1, 1)).toDisplay()).size() > 0) {
            umlDiagram.setFooter(display);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Empty footer");
    }
}

