/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.VerticalAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandMultilinesLegend
extends CommandMultilines2<UmlDiagram> {
    public CommandMultilinesLegend() {
        super(CommandMultilinesLegend.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("legend"), new RegexLeaf("VALIGN", "(?:[%s]+(top|bottom))?"), new RegexLeaf("ALIGN", "(?:[%s]+(left|right|center))?"), new RegexLeaf("$"));
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?legend$";
    }

    @Override
    public CommandExecutionResult executeNow(UmlDiagram umlDiagram, BlocLines blocLines) {
        blocLines = blocLines.trimSmart(1);
        RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
        String string = regexResult.get("ALIGN", 0);
        String string2 = regexResult.get("VALIGN", 0);
        blocLines = blocLines.subExtract(1, 1);
        Display display = (blocLines = blocLines.removeEmptyColumns()).toDisplay();
        if (display.size() > 0) {
            VerticalAlignment verticalAlignment = VerticalAlignment.fromString(string2);
            HorizontalAlignment horizontalAlignment = HorizontalAlignment.fromString(string);
            if (horizontalAlignment == null) {
                horizontalAlignment = HorizontalAlignment.CENTER;
            }
            umlDiagram.setLegend(display, horizontalAlignment, verticalAlignment);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("No legend defined");
    }
}

