/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.utils.UniqueSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandPackageEmpty
extends SingleLineCommand<AbstractEntityDiagram> {
    public CommandPackageEmpty() {
        super("(?i)^package[%s]+([%g][^%g]+[%g]|[^#%s{}]*)(?:[%s]+as[%s]+([\\p{L}0-9_.]+))?[%s]*(#[0-9a-fA-F]{6}|#?\\w+)?[%s]*\\{[%s]*\\}$");
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram abstractEntityDiagram, List<String> list) {
        String string;
        Code code;
        if (list.get(1) == null) {
            if (StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(list.get(0)).length() == 0) {
                code = Code.of("##" + UniqueSequence.getValue());
                string = null;
            } else {
                code = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(list.get(0)));
                string = code.getFullName();
            }
        } else {
            string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(list.get(0));
            code = Code.of(list.get(1));
        }
        IGroup iGroup = abstractEntityDiagram.getCurrentGroup();
        IGroup iGroup2 = abstractEntityDiagram.getOrCreateGroup(code, Display.getWithNewlines(string), GroupType.PACKAGE, iGroup);
        String string2 = list.get(2);
        if (string2 != null) {
            iGroup2.setSpecificColorTOBEREMOVED(ColorType.BACK, abstractEntityDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(string2));
        }
        abstractEntityDiagram.endGroup();
        return CommandExecutionResult.ok();
    }
}

