/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.utils.UniqueSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryNoteOnEntityCommand
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private final IRegex partialPattern;

    public FactoryNoteOnEntityCommand(IRegex iRegex) {
        this.partialPattern = iRegex;
    }

    private RegexConcat getRegexConcatSingleLine(IRegex iRegex) {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)"), new RegexOr(new RegexConcat(new RegexLeaf("[%s]+of[%s]+"), iRegex), new RegexLeaf("")), new RegexLeaf("[%s]*"), FactoryNoteOnEntityCommand.color().getRegex(), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    private RegexConcat getRegexConcatMultiLine(IRegex iRegex, boolean bl) {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)"), new RegexOr(new RegexConcat(new RegexLeaf("[%s]+of[%s]+"), iRegex), new RegexLeaf("")), new RegexLeaf("[%s]*"), FactoryNoteOnEntityCommand.color().getRegex(), new RegexLeaf(bl ? "[%s]*\\{" : "[%s]*"), new RegexLeaf("$"));
    }

    @Override
    public Command<AbstractEntityDiagram> createSingleLine() {
        return new SingleLineCommand2<AbstractEntityDiagram>(this.getRegexConcatSingleLine(this.partialPattern)){

            @Override
            protected CommandExecutionResult executeArg(AbstractEntityDiagram abstractEntityDiagram, RegexResult regexResult) {
                String string = regexResult.get("NOTE", 0);
                return FactoryNoteOnEntityCommand.this.executeInternal(regexResult, abstractEntityDiagram, null, BlocLines.getWithNewlines(string));
            }
        };
    }

    @Override
    public Command<AbstractEntityDiagram> createMultiLine(final boolean bl) {
        return new CommandMultilines2<AbstractEntityDiagram>(this.getRegexConcatMultiLine(this.partialPattern, bl), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                if (bl) {
                    return "(?i)^(\\})$";
                }
                return "(?i)^[%s]*(end[%s]?note)$";
            }

            @Override
            public CommandExecutionResult executeNow(AbstractEntityDiagram abstractEntityDiagram, BlocLines blocLines) {
                RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
                blocLines = blocLines.subExtract(1, 1);
                blocLines = blocLines.removeEmptyColumns();
                Url url = null;
                if (blocLines.size() > 0) {
                    UrlBuilder urlBuilder = new UrlBuilder(abstractEntityDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                    url = urlBuilder.getUrl(blocLines.getFirst499().toString());
                }
                if (url != null) {
                    blocLines = blocLines.subExtract(1, 0);
                }
                return FactoryNoteOnEntityCommand.this.executeInternal(regexResult, abstractEntityDiagram, url, blocLines);
            }
        };
    }

    private CommandExecutionResult executeInternal(RegexResult regexResult, AbstractEntityDiagram abstractEntityDiagram, Url url, BlocLines blocLines) {
        Link link;
        IEntity iEntity;
        String string = regexResult.get("POSITION", 0);
        Code code = Code.of(regexResult.get("ENTITY", 0));
        if (code == null) {
            iEntity = abstractEntityDiagram.getLastEntity();
            if (iEntity == null) {
                return CommandExecutionResult.error("Nothing to note to");
            }
        } else {
            iEntity = abstractEntityDiagram.isGroup(code) ? abstractEntityDiagram.getGroup(code) : abstractEntityDiagram.getOrCreateLeaf(code, null, null);
        }
        ILeaf iLeaf = abstractEntityDiagram.createLeaf(UniqueSequence.getCode("GMN"), blocLines.toDisplay(), LeafType.NOTE, null);
        Colors colors = FactoryNoteOnEntityCommand.color().getColor(regexResult, abstractEntityDiagram.getSkinParam().getIHtmlColorSet());
        iLeaf.setColors(colors);
        if (url != null) {
            iLeaf.addUrl(url);
        }
        Position position = Position.valueOf(StringUtils.goUpperCase(string)).withRankdir(abstractEntityDiagram.getSkinParam().getRankdir());
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getDashed();
        if (position == Position.RIGHT) {
            link = new Link(iEntity, iLeaf, linkType, Display.NULL, 1);
            link.setHorizontalSolitary(true);
        } else if (position == Position.LEFT) {
            link = new Link(iLeaf, iEntity, linkType, Display.NULL, 1);
            link.setHorizontalSolitary(true);
        } else if (position == Position.BOTTOM) {
            link = new Link(iEntity, iLeaf, linkType, Display.NULL, 2);
        } else if (position == Position.TOP) {
            link = new Link(iLeaf, iEntity, linkType, Display.NULL, 2);
        } else {
            throw new IllegalArgumentException();
        }
        abstractEntityDiagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

