/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;

public class CommandCreoleMonospaced
implements Command {
    public static final String MONOSPACED = "monospaced";
    private final Pattern pattern;
    private final String monospacedFamily;

    public static Command create(String string) {
        return new CommandCreoleMonospaced("^(?i)([%g][%g](.*?)[%g][%g])", string);
    }

    private CommandCreoleMonospaced(String string, String string2) {
        this.pattern = MyPattern.cmpile(string);
        this.monospacedFamily = string2;
    }

    public int matchingSize(String string) {
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.find()) {
            return 0;
        }
        return matcher.group(1).length();
    }

    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fontConfiguration = stripeSimple.getActualFontConfiguration();
        FontConfiguration fontConfiguration2 = fontConfiguration.changeFamily(this.monospacedFamily);
        stripeSimple.setActualFontConfiguration(fontConfiguration2);
        stripeSimple.analyzeAndAdd(matcher.group(2));
        stripeSimple.setActualFontConfiguration(fontConfiguration);
        return string.substring(matcher.group(1).length());
    }
}

