/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MemberImpl;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.skin.VisibilityModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bodier {
    private final List<String> rawBody = new ArrayList<String>();
    private final Set<VisibilityModifier> hides;
    private LeafType type;
    private List<Member> methodsToDisplay;
    private List<Member> fieldsToDisplay;
    private final boolean manageModifier;

    public void muteClassToObject() {
        this.methodsToDisplay = null;
        this.fieldsToDisplay = null;
        this.type = LeafType.OBJECT;
    }

    public Bodier(LeafType leafType, Set<VisibilityModifier> set) {
        this.hides = set;
        this.type = leafType;
        this.manageModifier = leafType == null ? false : leafType.manageModifier();
    }

    public void addFieldOrMethod(String string) {
        this.methodsToDisplay = null;
        this.fieldsToDisplay = null;
        this.rawBody.add(string);
    }

    private boolean isBodyEnhanced() {
        for (String string : this.rawBody) {
            if (!BodyEnhanced.isBlockSeparator(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethod(String string) {
        if (this.type == LeafType.ANNOTATION || this.type == LeafType.ABSTRACT_CLASS || this.type == LeafType.CLASS || this.type == LeafType.INTERFACE || this.type == LeafType.ENUM) {
            return MemberImpl.isMethod(string);
        }
        return false;
    }

    public List<Member> getMethodsToDisplay() {
        if (this.methodsToDisplay == null) {
            this.methodsToDisplay = new ArrayList<Member>();
            for (int i = 0; i < this.rawBody.size(); ++i) {
                String string = this.rawBody.get(i);
                if (!this.isMethod(i, this.rawBody) || string.length() == 0 && this.methodsToDisplay.size() == 0) continue;
                MemberImpl memberImpl = new MemberImpl(string, true, this.manageModifier, true);
                if (this.hides != null && this.hides.contains((Object)memberImpl.getVisibilityModifier())) continue;
                this.methodsToDisplay.add(memberImpl);
            }
            this.removeFinalEmptyMembers(this.methodsToDisplay);
        }
        return Collections.unmodifiableList(this.methodsToDisplay);
    }

    private boolean isMethod(int n, List<String> list) {
        if (n > 0 && n < list.size() - 1 && list.get(n).length() == 0 && this.isMethod(list.get(n - 1)) && this.isMethod(list.get(n + 1))) {
            return true;
        }
        return this.isMethod(list.get(n));
    }

    public List<Member> getFieldsToDisplay() {
        if (this.fieldsToDisplay == null) {
            this.fieldsToDisplay = new ArrayList<Member>();
            for (String string : this.rawBody) {
                if (this.isMethod(string) || string.length() == 0 && this.fieldsToDisplay.size() == 0) continue;
                MemberImpl memberImpl = new MemberImpl(string, false, this.manageModifier, true);
                if (this.hides != null && this.hides.contains((Object)memberImpl.getVisibilityModifier())) continue;
                this.fieldsToDisplay.add(memberImpl);
            }
            this.removeFinalEmptyMembers(this.fieldsToDisplay);
        }
        return Collections.unmodifiableList(this.fieldsToDisplay);
    }

    private void removeFinalEmptyMembers(List<Member> list) {
        while (list.size() > 0 && StringUtils.trin(list.get(list.size() - 1).getDisplay(false)).length() == 0) {
            list.remove(list.size() - 1);
        }
    }

    public boolean hasUrl() {
        for (Member member : this.getFieldsToDisplay()) {
            if (!member.hasUrl()) continue;
            return true;
        }
        for (Member member : this.getMethodsToDisplay()) {
            if (!member.hasUrl()) continue;
            return true;
        }
        return true;
    }

    public TextBlock getBody(FontParam fontParam, ISkinParam iSkinParam, boolean bl, boolean bl2) {
        if (this.type.isLikeClass() && this.isBodyEnhanced()) {
            if (bl || bl2) {
                return new BodyEnhanced(this.rawBody, fontParam, iSkinParam, this.manageModifier);
            }
            return null;
        }
        MethodsOrFieldsArea methodsOrFieldsArea = new MethodsOrFieldsArea(this.getFieldsToDisplay(), fontParam, iSkinParam);
        if (this.type == LeafType.OBJECT) {
            return methodsOrFieldsArea.asBlockMemberImpl();
        }
        if (!this.type.isLikeClass()) {
            throw new UnsupportedOperationException();
        }
        MethodsOrFieldsArea methodsOrFieldsArea2 = new MethodsOrFieldsArea(this.getMethodsToDisplay(), fontParam, iSkinParam);
        if (bl2 && !bl) {
            return methodsOrFieldsArea.asBlockMemberImpl();
        }
        if (bl && !bl2) {
            return methodsOrFieldsArea2.asBlockMemberImpl();
        }
        if (!bl2 && !bl) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        TextBlock textBlock = methodsOrFieldsArea.asBlockMemberImpl();
        TextBlock textBlock2 = methodsOrFieldsArea2.asBlockMemberImpl();
        return new TextBlockVertical2(textBlock, textBlock2, HorizontalAlignment.LEFT);
    }
}

