/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.Removeable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbolInterface;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class Link
implements Hideable,
Removeable {
    private final IEntity cl1;
    private final IEntity cl2;
    private LinkType type;
    private final Display label;
    private int length;
    private final String qualifier1;
    private final String qualifier2;
    private final String uid = "LNK" + UniqueSequence.getValue();
    private Display note;
    private Position notePosition;
    private Colors noteColors;
    private boolean invis = false;
    private double weight = 1.0;
    private final String labeldistance;
    private final String labelangle;
    private HtmlColor specificColor;
    private boolean constraint = true;
    private boolean inverted = false;
    private LinkArrow linkArrow = LinkArrow.NONE;
    private boolean opale;
    private boolean horizontalSolitary;
    private String sametail;
    private Url url;
    private boolean hidden = false;
    private Colors colors;

    public Link(IEntity iEntity, IEntity iEntity2, LinkType linkType, Display display, int n) {
        this(iEntity, iEntity2, linkType, display, n, null, null, null, null, null);
    }

    public Link(IEntity iEntity, IEntity iEntity2, LinkType linkType, Display display, int n, String string, String string2, String string3, String string4) {
        this(iEntity, iEntity2, linkType, display, n, string, string2, string3, string4, null);
    }

    public Link(IEntity iEntity, IEntity iEntity2, LinkType linkType, Display display, int n, String string, String string2, String string3, String string4, HtmlColor htmlColor) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        if (iEntity == null) {
            throw new IllegalArgumentException();
        }
        if (iEntity2 == null) {
            throw new IllegalArgumentException();
        }
        this.cl1 = iEntity;
        this.cl2 = iEntity2;
        this.type = linkType;
        if (Display.isNull(display)) {
            this.label = Display.NULL;
        } else if (Link.doWeHaveToRemoveUrlAtStart(display)) {
            this.url = display.initUrl();
            this.label = display.removeUrl(this.url);
        } else {
            this.label = display;
        }
        this.length = n;
        this.qualifier1 = string;
        this.qualifier2 = string2;
        this.labeldistance = string3;
        this.labelangle = string4;
        this.specificColor = htmlColor;
        if (string != null) {
            ((ILeaf)iEntity).setNearDecoration(true);
        }
        if (string2 != null) {
            ((ILeaf)iEntity2).setNearDecoration(true);
        }
    }

    private static boolean doWeHaveToRemoveUrlAtStart(Display display) {
        if (display.size() == 0) {
            return false;
        }
        String string = display.get(0).toString();
        return string.matches("^\\[\\[\\S+\\]\\].+$");
    }

    public Link getInv() {
        Link link = new Link(this.cl2, this.cl1, this.getType().getInversed(), this.label, this.length, this.qualifier2, this.qualifier1, this.labeldistance, this.labelangle, this.specificColor);
        link.inverted = true;
        return link;
    }

    public void goDashed() {
        this.type = this.type.getDashed();
    }

    public void goDotted() {
        this.type = this.type.getDotted();
    }

    public void goHidden() {
        this.hidden = true;
    }

    public void goNorank() {
        this.setConstraint(false);
    }

    public void goBold() {
        this.type = this.type.getBold();
    }

    public String getLabeldistance() {
        return this.labeldistance;
    }

    public String getLabelangle() {
        return this.labelangle;
    }

    public String getUid() {
        return this.uid;
    }

    public final boolean isInvis() {
        if (this.type.isInvisible()) {
            return true;
        }
        return this.invis;
    }

    public final void setInvis(boolean bl) {
        this.invis = bl;
    }

    public boolean isBetween(IEntity iEntity, IEntity iEntity2) {
        if (iEntity.equals(this.cl1) && iEntity2.equals(this.cl2)) {
            return true;
        }
        return iEntity.equals(this.cl2) && iEntity2.equals(this.cl1);
    }

    public String toString() {
        return super.toString() + " {" + this.length + "} " + this.cl1 + "-->" + this.cl2;
    }

    public IEntity getEntity1() {
        return this.cl1;
    }

    public IEntity getEntity2() {
        return this.cl2;
    }

    public LinkType getType() {
        if (this.opale) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        if (this.getSametail() != null) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        LinkType linkType = this.type;
        return linkType;
    }

    private LinkType getTypeSpecialForPrinting() {
        if (this.opale) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        LinkType linkType = this.type;
        return linkType;
    }

    private boolean isLollipopInterfaceEye(IEntity iEntity) {
        return iEntity.getUSymbol() instanceof USymbolInterface;
    }

    public Display getLabel() {
        return this.label;
    }

    public int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public String getQualifier1() {
        return this.qualifier1;
    }

    public String getQualifier2() {
        return this.qualifier2;
    }

    public final double getWeight() {
        return this.weight;
    }

    public final void setWeight(double d) {
        this.weight = d;
    }

    public final Display getNote() {
        return this.note;
    }

    public final Colors getNoteColors() {
        return this.noteColors;
    }

    public final Position getNotePosition() {
        return this.notePosition;
    }

    public final void addNote(Display display, Position position, Colors colors) {
        this.note = display;
        this.notePosition = position;
        this.noteColors = colors;
    }

    public boolean isAutoLinkOfAGroup() {
        if (!this.getEntity1().isGroup()) {
            return false;
        }
        if (!this.getEntity2().isGroup()) {
            return false;
        }
        return this.getEntity1() == this.getEntity2();
    }

    public boolean containsType(LeafType leafType) {
        return this.getEntity1().getEntityType() == leafType || this.getEntity2().getEntityType() == leafType;
    }

    public boolean contains(IEntity iEntity) {
        return this.getEntity1() == iEntity || this.getEntity2() == iEntity;
    }

    public IEntity getOther(IEntity iEntity) {
        if (this.getEntity1() == iEntity) {
            return this.getEntity2();
        }
        if (this.getEntity2() == iEntity) {
            return this.getEntity1();
        }
        throw new IllegalArgumentException();
    }

    public double getMarginDecors1(StringBounder stringBounder, UFont uFont, ISkinSimple iSkinSimple) {
        double d = this.getQualifierMargin(stringBounder, uFont, this.qualifier1, iSkinSimple);
        LinkDecor linkDecor = this.getType().getDecor1();
        return (double)linkDecor.getMargin() + d;
    }

    public double getMarginDecors2(StringBounder stringBounder, UFont uFont, ISkinSimple iSkinSimple) {
        double d = this.getQualifierMargin(stringBounder, uFont, this.qualifier2, iSkinSimple);
        LinkDecor linkDecor = this.getType().getDecor2();
        return (double)linkDecor.getMargin() + d;
    }

    private double getQualifierMargin(StringBounder stringBounder, UFont uFont, String string, ISkinSimple iSkinSimple) {
        if (string != null) {
            TextBlock textBlock = Display.create(string).create(FontConfiguration.blackBlueTrue(uFont), HorizontalAlignment.LEFT, iSkinSimple);
            Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
            return Math.max(dimension2D.getWidth(), dimension2D.getHeight());
        }
        return 0.0;
    }

    public HtmlColor getSpecificColor() {
        return this.specificColor;
    }

    public void setSpecificColor(String string) {
        this.specificColor = HtmlColorSet.getInstance().getColorIfValid(string);
    }

    public final boolean isConstraint() {
        return this.constraint;
    }

    public final void setConstraint(boolean bl) {
        this.constraint = bl;
    }

    public void setOpale(boolean bl) {
        this.opale = bl;
    }

    public final void setHorizontalSolitary(boolean bl) {
        this.horizontalSolitary = bl;
    }

    public final boolean isHorizontalSolitary() {
        return this.horizontalSolitary;
    }

    public final LinkArrow getLinkArrow() {
        if (this.inverted) {
            return this.linkArrow.reverse();
        }
        return this.linkArrow;
    }

    public final void setLinkArrow(LinkArrow linkArrow) {
        this.linkArrow = linkArrow;
    }

    public final boolean isInverted() {
        return this.inverted;
    }

    public boolean hasEntryPoint() {
        return !this.getEntity1().isGroup() && ((ILeaf)this.getEntity1()).getEntityPosition() != EntityPosition.NORMAL || !this.getEntity2().isGroup() && ((ILeaf)this.getEntity2()).getEntityPosition() != EntityPosition.NORMAL;
    }

    public boolean hasTwoEntryPointsSameContainer() {
        return !this.getEntity1().isGroup() && !this.getEntity2().isGroup() && ((ILeaf)this.getEntity1()).getEntityPosition() != EntityPosition.NORMAL && ((ILeaf)this.getEntity2()).getEntityPosition() != EntityPosition.NORMAL && this.getEntity1().getParentContainer() == this.getEntity2().getParentContainer();
    }

    public Url getUrl() {
        return this.url;
    }

    public void setUrl(Url url) {
        this.url = url;
    }

    public boolean isHidden() {
        return this.hidden || this.cl1.isHidden() || this.cl2.isHidden();
    }

    public boolean sameConnections(Link link) {
        if (this.cl1 == link.cl1 && this.cl2 == link.cl2) {
            return true;
        }
        return this.cl1 == link.cl2 && this.cl2 == link.cl1;
    }

    public boolean doesTouch(Link link) {
        if (this.cl1 == link.cl1) {
            return true;
        }
        if (this.cl1 == link.cl2) {
            return true;
        }
        if (this.cl2 == link.cl1) {
            return true;
        }
        return this.cl2 == link.cl2;
    }

    public boolean isAutolink() {
        return this.cl1 == this.cl2;
    }

    public boolean isRemoved() {
        return this.cl1.isRemoved() || this.cl2.isRemoved();
    }

    public boolean hasUrl() {
        if (!Display.isNull(this.label) && this.label.hasUrl()) {
            return true;
        }
        return this.getUrl() != null;
    }

    public String getSametail() {
        return this.sametail;
    }

    public void setSametail(String string) {
        this.sametail = string;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public final Colors getColors() {
        return this.colors;
    }
}

