/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neighborhood {
    private final ILeaf leaf;
    private final List<Link> sametailLinks;
    private final List<Link> allButSametails;
    private static final double epsilon = 0.001;

    public Neighborhood(ILeaf iLeaf, List<Link> list, List<Link> list2) {
        this.leaf = iLeaf;
        this.sametailLinks = list;
        this.allButSametails = new ArrayList<Link>(list2);
        this.allButSametails.removeAll(list);
    }

    public void drawU(UGraphic uGraphic, double d, double d2, Bibliotekon bibliotekon, Dimension2D dimension2D) {
        Object object;
        HashSet<Point2D> hashSet = new HashSet<Point2D>();
        for (Link object22 : this.sametailLinks) {
            Iterator<Link> iterator = bibliotekon.getLine(object22);
            Point2D point2D = ((Line)((Object)iterator)).getStartContactPoint();
            hashSet.add(point2D);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
        Point2D.Double double_2 = new Point2D.Double(double_.getCenterX(), double_.getCenterY());
        for (Point2D point2D : hashSet) {
            object = Neighborhood.intersection(double_, double_2, point2D);
            if (object == null) {
                assert (false);
                continue;
            }
            double d3 = Math.atan2(((Point2D)double_2).getX() - point2D.getX(), -(((Point2D)double_2).getY() - point2D.getY()));
            Point2D point2D2 = this.drawExtends(uGraphic, (Point2D)object, d3);
            this.drawLine(uGraphic, point2D2, point2D);
        }
        for (Link link : this.allButSametails) {
            Point2D point2D;
            object = bibliotekon.getLine(link);
            Point2D point2D3 = point2D = link.getEntity1() == this.leaf ? ((Line)object).getStartContactPoint() : ((Line)object).getEndContactPoint();
            if (point2D == null) {
                assert (false);
                continue;
            }
            Point2D point2D4 = Neighborhood.intersection(double_, double_2, point2D);
            if (point2D4 == null) {
                assert (false);
                continue;
            }
            this.drawLine(uGraphic, point2D4, point2D);
        }
    }

    private Point2D drawExtends(UGraphic uGraphic, Point2D point2D, double d) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(7.0, 20.0);
        uPolygon.addPoint(-7.0, 20.0);
        uPolygon.rotate(d);
        UTranslate uTranslate = new UTranslate(point2D);
        uGraphic.apply(uTranslate).draw(uPolygon);
        Point2D point2D2 = uTranslate.getTranslated(uPolygon.getPoints().get(1));
        Point2D point2D3 = uTranslate.getTranslated(uPolygon.getPoints().get(2));
        return new Point2D.Double((point2D2.getX() + point2D3.getX()) / 2.0, (point2D2.getY() + point2D3.getY()) / 2.0);
    }

    static Point2D intersection(Rectangle2D rectangle2D, Point2D point2D, Point2D point2D2) {
        Point2D point2D3 = Neighborhood.intersection(new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY()), new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMinY()), point2D, point2D2);
        if (point2D3 != null) {
            return point2D3;
        }
        point2D3 = Neighborhood.intersection(new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMaxY()), new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMaxY()), point2D, point2D2);
        if (point2D3 != null) {
            return point2D3;
        }
        point2D3 = Neighborhood.intersection(new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY()), new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMaxY()), point2D, point2D2);
        if (point2D3 != null) {
            return point2D3;
        }
        point2D3 = Neighborhood.intersection(new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMinY()), new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMaxY()), point2D, point2D2);
        if (point2D3 != null) {
            return point2D3;
        }
        return null;
    }

    private static Point2D intersection(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        return Neighborhood.intersection(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY());
    }

    private static Point2D intersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = (d - d3) * (d6 - d8) - (d2 - d4) * (d5 - d7);
        if (d9 == 0.0) {
            return null;
        }
        double d10 = ((d5 - d7) * (d * d4 - d2 * d3) - (d - d3) * (d5 * d8 - d6 * d7)) / d9;
        double d11 = ((d6 - d8) * (d * d4 - d2 * d3) - (d2 - d4) * (d5 * d8 - d6 * d7)) / d9;
        Point2D.Double double_ = new Point2D.Double(d10, d11);
        if (d10 + 0.001 < Math.min(d, d3) || d10 - 0.001 > Math.max(d, d3)) {
            return null;
        }
        if (d10 + 0.001 < Math.min(d5, d7) || d10 - 0.001 > Math.max(d5, d7)) {
            return null;
        }
        if (d11 + 0.001 < Math.min(d2, d4) || d11 - 0.001 > Math.max(d2, d4)) {
            return null;
        }
        if (d11 + 0.001 < Math.min(d6, d8) || d11 - 0.001 > Math.max(d6, d8)) {
            return null;
        }
        return double_;
    }

    private void drawLine(UGraphic uGraphic, Point2D point2D, Point2D point2D2) {
        this.drawLine(uGraphic, point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    private void drawLine(UGraphic uGraphic, double d, double d2, double d3, double d4) {
        ULine uLine = new ULine(d3 - d, d4 - d2);
        uGraphic.apply(new UTranslate(d, d2)).draw(uLine);
    }
}

