/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.cute.RotationZoom;

public class MyPoint2D
extends Point2D {
    public static final double NO_CURVE = 0.0;
    private final double x;
    private final double y;
    private final double curvation;

    public MyPoint2D(StringTokenizer stringTokenizer) {
        this.x = Double.parseDouble(stringTokenizer.nextToken());
        this.y = Double.parseDouble(stringTokenizer.nextToken());
        this.curvation = stringTokenizer.hasMoreTokens() ? Double.parseDouble(stringTokenizer.nextToken()) : 0.0;
    }

    public boolean equals(Object object) {
        MyPoint2D myPoint2D = (MyPoint2D)object;
        return this.x == myPoint2D.x && this.y == myPoint2D.y && this.curvation == myPoint2D.curvation;
    }

    public static MyPoint2D from(double d, double d2) {
        return new MyPoint2D(d, d2, 0.0);
    }

    public MyPoint2D withCurvation(double d) {
        if (d == 0.0) {
            return this;
        }
        return new MyPoint2D(this.x, this.y, d);
    }

    private MyPoint2D(Point2D point2D, double d) {
        this.x = point2D.getX();
        this.y = point2D.getY();
        this.curvation = d;
    }

    private MyPoint2D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.curvation = d3;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public double getCurvation(double d) {
        if (this.curvation == 0.0) {
            return d;
        }
        return this.curvation;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setLocation(double d, double d2) {
        throw new UnsupportedOperationException();
    }

    public MyPoint2D rotateZoom(RotationZoom rotationZoom) {
        Point2D.Double double_ = rotationZoom.getPoint(this.x, this.y);
        double d = this.curvation == 0.0 ? 0.0 : rotationZoom.applyZoom(this.curvation);
        return new MyPoint2D(double_, d);
    }

    public boolean hasCurvation() {
        return this.curvation != 0.0;
    }
}

