/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateElementFull
extends SingleLineCommand2<DescriptionDiagram> {
    private static final String CODE_CORE = "[\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]";
    private static final String CODE = "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])";
    private static final String CODE_WITH_QUOTE = "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[%g][^%g]+[%g])";
    private static final String DISPLAY_CORE = "[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]";
    private static final String DISPLAY = "([%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])";
    private static final String DISPLAY_WITHOUT_QUOTE = "([%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[\\p{L}0-9_.]+)";

    public CommandCreateElementFull() {
        super(CommandCreateElementFull.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("SYMBOL", "(?:(artifact|actor|folder|package|rectangle|node|frame|cloud|database|queue|storage|agent|usecase|component|boundary|control|entity|interface|\\(\\))[%s]+)?"), new RegexLeaf("[%s]*"), new RegexOr(new RegexLeaf("CODE1", CODE_WITH_QUOTE), new RegexConcat(new RegexLeaf("DISPLAY2", DISPLAY), new RegexLeaf("STEREOTYPE2", "(?:[%s]+(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*as[%s]+"), new RegexLeaf("CODE2", CODE)), new RegexConcat(new RegexLeaf("CODE3", CODE), new RegexLeaf("STEREOTYPE3", "(?:[%s]+(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]+as[%s]*"), new RegexLeaf("DISPLAY3", DISPLAY)), new RegexConcat(new RegexLeaf("DISPLAY4", DISPLAY_WITHOUT_QUOTE), new RegexLeaf("STEREOTYPE4", "(?:[%s]+(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*as[%s]+"), new RegexLeaf("CODE4", CODE))), new RegexLeaf("STEREOTYPE", "(?:[%s]*(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), CommandCreateElementFull.color().getRegex(), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected final boolean isForbidden(CharSequence charSequence) {
        return charSequence.toString().matches("^[\\p{L}0-9_.]+$");
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram descriptionDiagram, RegexResult regexResult) {
        Object object;
        Object object2;
        String string;
        USymbol uSymbol;
        LeafType leafType;
        String string2;
        String string3 = regexResult.getLazzy("CODE", 0);
        String string4 = regexResult.getLazzy("DISPLAY", 0);
        char c = this.getCharEncoding(string3);
        char c2 = this.getCharEncoding(string4);
        if (string3.startsWith("()")) {
            string2 = "interface";
            string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(string3.substring(2)));
        } else {
            string2 = c == '(' || c2 == '(' ? "usecase" : (c == ':' || c2 == ':' ? "actor" : (c == '[' || c2 == '[' ? "component" : regexResult.get("SYMBOL", 0)));
        }
        if (string2 == null) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.ACTOR;
        } else if (string2.equalsIgnoreCase("artifact")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.ARTIFACT;
        } else if (string2.equalsIgnoreCase("folder")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.FOLDER;
        } else if (string2.equalsIgnoreCase("package")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.PACKAGE;
        } else if (string2.equalsIgnoreCase("rectangle")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.RECTANGLE;
        } else if (string2.equalsIgnoreCase("node")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.NODE;
        } else if (string2.equalsIgnoreCase("frame")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.FRAME;
        } else if (string2.equalsIgnoreCase("cloud")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.CLOUD;
        } else if (string2.equalsIgnoreCase("database")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.DATABASE;
        } else if (string2.equalsIgnoreCase("queue")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.QUEUE;
        } else if (string2.equalsIgnoreCase("storage")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.STORAGE;
        } else if (string2.equalsIgnoreCase("agent")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.AGENT;
        } else if (string2.equalsIgnoreCase("actor")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.ACTOR;
        } else if (string2.equalsIgnoreCase("component")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = descriptionDiagram.getSkinParam().useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1;
        } else if (string2.equalsIgnoreCase("boundary")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.BOUNDARY;
        } else if (string2.equalsIgnoreCase("control")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.CONTROL;
        } else if (string2.equalsIgnoreCase("entity")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.ENTITY_DOMAIN;
        } else if (string2.equalsIgnoreCase("interface")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.INTERFACE;
        } else if (string2.equalsIgnoreCase("()")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.INTERFACE;
        } else if (string2.equalsIgnoreCase("usecase")) {
            leafType = LeafType.USECASE;
            uSymbol = null;
        } else {
            throw new IllegalStateException();
        }
        Code code = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string3));
        String string5 = string4;
        if (string5 == null) {
            string5 = code.getFullName();
        }
        string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string5);
        String string6 = regexResult.getLazzy("STEREOTYPE", 0);
        ILeaf iLeaf = descriptionDiagram.getOrCreateLeaf(code, leafType, uSymbol);
        iLeaf.setDisplay(Display.getWithNewlines(string5));
        iLeaf.setUSymbol(uSymbol);
        if (string6 != null) {
            iLeaf.setStereotype(new Stereotype(string6, descriptionDiagram.getSkinParam().getCircledCharacterRadius(), descriptionDiagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), descriptionDiagram.getSkinParam().getIHtmlColorSet()));
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            object2 = new UrlBuilder(descriptionDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            object = ((UrlBuilder)object2).getUrl(string);
            iLeaf.addUrl((Url)object);
        }
        object2 = CommandCreateElementFull.color().getColor(regexResult, descriptionDiagram.getSkinParam().getIHtmlColorSet());
        object = descriptionDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("LINECOLOR", 1));
        if (object != null) {
            object2 = ((Colors)object2).add(ColorType.LINE, (HtmlColor)object);
        }
        iLeaf.setColors((Colors)object2);
        return CommandExecutionResult.ok();
    }

    private char getCharEncoding(String string) {
        return string != null && string.length() > 2 ? string.charAt(0) : (char)'\u0000';
    }
}

