/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

class EntityImageDefault
extends AbstractEntityImage {
    private final TextBlock textBlock;

    public EntityImageDefault(IEntity iEntity) {
        super(iEntity);
        this.textBlock = iEntity.getDisplay().create(FontConfiguration.blackBlueTrue(this.getFont14()), HorizontalAlignment.CENTER, new SpriteContainerEmpty());
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return new Dimension2DDouble(dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void draw(ColorMapper colorMapper, Graphics2D graphics2D) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(StringBounderUtils.asStringBounder(graphics2D));
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(0, 0, n, n2);
    }
}

