/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockBordered;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;
import net.sourceforge.plantuml.webp.Portrait;
import net.sourceforge.plantuml.webp.Portraits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateEventUtils {
    public static TextBlock addEvent(TextBlock textBlock, HtmlColor htmlColor) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd");
        String string = simpleDateFormat.format(new Date());
        if ("11-05".equals(string)) {
            List<String> list = Arrays.asList("<u>November 5th, 1955", "Doc Brown's discovery of the Flux Capacitor, that makes time-travel possible.");
            return TextBlockUtils.mergeTB(textBlock, DateEventUtils.getComment(list, htmlColor), HorizontalAlignment.LEFT);
        }
        if ("08-29".equals(string)) {
            List<String> list = Arrays.asList("<u>August 29th, 1997", "Skynet becomes self-aware at 02:14 AM Eastern Time.");
            return TextBlockUtils.mergeTB(textBlock, DateEventUtils.getComment(list, htmlColor), HorizontalAlignment.LEFT);
        }
        if ("06-29".equals(string)) {
            List<String> list = Arrays.asList("<u>June 29th, 1975", "\"It was the first time in history that anyone had typed", "a character on a keyboard and seen it show up on their", "own computer's screen right in front of them.\"", "\t\t\t\t\t\t\t\t\t\t<i>Steve Wozniak");
            return TextBlockUtils.mergeTB(textBlock, DateEventUtils.getComment(list, htmlColor), HorizontalAlignment.LEFT);
        }
        if ("01-07".equals(string) || "01-08".equals(string)) {
            return DateEventUtils.addCharlie(textBlock);
        }
        return textBlock;
    }

    private static TextBlock addMemorial(TextBlock textBlock, HtmlColor htmlColor) {
        Portrait portrait = new Portraits().getOne();
        if (portrait == null) {
            return textBlock;
        }
        final BufferedImage bufferedImage = portrait.getBufferedImage();
        if (bufferedImage == null) {
            return textBlock;
        }
        List<String> list = Arrays.asList("A thought for those who died in Paris the 13th November 2015.");
        String string = portrait.getName();
        UFont uFont = new UFont("SansSerif", 1, 12);
        TextBlock textBlock2 = Display.create(string).create(new FontConfiguration(uFont, htmlColor, HtmlColorUtils.BLUE, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        textBlock2 = TextBlockUtils.withMargin(textBlock2, 4.0, 4.0);
        TextBlock textBlock3 = DateEventUtils.getComment(list, htmlColor);
        AbstractTextBlock abstractTextBlock = new AbstractTextBlock(){
            private double margin = 10.0;

            public void drawU(UGraphic uGraphic) {
                uGraphic = uGraphic.apply(new UTranslate(0.0, this.margin));
                uGraphic.draw(new UImage(bufferedImage));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(bufferedImage.getWidth(), this.margin + (double)bufferedImage.getHeight());
            }
        };
        TextBlock textBlock4 = TextBlockUtils.mergeTB(textBlock3, TextBlockUtils.mergeLR(abstractTextBlock, textBlock2, VerticalAlignment.CENTER), HorizontalAlignment.LEFT);
        return TextBlockUtils.mergeTB(textBlock, textBlock4, HorizontalAlignment.LEFT);
    }

    private static TextBlock addCharlie(TextBlock textBlock) {
        AbstractTextBlock abstractTextBlock = new AbstractTextBlock(){
            private final BufferedImage charlie = PSystemVersion.getCharlieImage();

            public void drawU(UGraphic uGraphic) {
                uGraphic.draw(new UImage(this.charlie));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(this.charlie.getWidth(), this.charlie.getHeight());
            }
        };
        return TextBlockUtils.mergeTB(abstractTextBlock, textBlock, HorizontalAlignment.LEFT);
    }

    private static TextBlock getComment(List<String> list, HtmlColor htmlColor) {
        UFont uFont = new UFont("SansSerif", 1, 14);
        TextBlock textBlock = Display.create(list).create(new FontConfiguration(uFont, htmlColor, HtmlColorUtils.BLUE, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        textBlock = TextBlockUtils.withMargin(textBlock, 4.0, 4.0);
        textBlock = new TextBlockBordered(textBlock, htmlColor);
        textBlock = TextBlockUtils.withMargin(textBlock, 10.0, 10.0);
        return textBlock;
    }
}

