/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmbededDiagram;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Line;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;

class EmbededSystemLine
extends AbstractTextBlock
implements Line {
    private final List<CharSequence2> lines2;

    public EmbededSystemLine(EmbededDiagram embededDiagram) {
        this.lines2 = embededDiagram.getLines().as2();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        try {
            BufferedImage bufferedImage = this.getImage();
            return new Dimension2DDouble(bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return new Dimension2DDouble(42.0, 42.0);
    }

    public void drawU(UGraphic uGraphic) {
        try {
            BufferedImage bufferedImage = this.getImage();
            UImage uImage = new UImage(bufferedImage);
            uGraphic.draw(uImage);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private BufferedImage getImage() throws IOException, InterruptedException {
        Diagram diagram = this.getSystem();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        diagram.exportDiagram(byteArrayOutputStream, 0, new FileFormatOption(FileFormat.PNG));
        byteArrayOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
        byteArrayInputStream.close();
        return bufferedImage;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return HorizontalAlignment.LEFT;
    }

    private Diagram getSystem() throws IOException, InterruptedException {
        BlockUml blockUml = new BlockUml(this.lines2, 0);
        return blockUml.getDiagram();
    }
}

