/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockSpotted
extends TextBlockSimple {
    private final CircledCharacter circledCharacter;

    public TextBlockSpotted(CircledCharacter circledCharacter, Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer) {
        super(display, fontConfiguration, horizontalAlignment, spriteContainer, 0.0);
        this.circledCharacter = circledCharacter;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = this.getCircledCharacterWithAndMargin(stringBounder);
        double d2 = this.circledCharacter.getPreferredHeight(stringBounder);
        Dimension2D dimension2D = super.calculateDimension(stringBounder);
        return new Dimension2DDouble(dimension2D.getWidth() + d, Math.max(d2, dimension2D.getHeight()));
    }

    private double getCircledCharacterWithAndMargin(StringBounder stringBounder) {
        return this.circledCharacter.getPreferredWidth(stringBounder) + 6.0;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        this.circledCharacter.drawU(uGraphic);
        double d = this.getCircledCharacterWithAndMargin(stringBounder);
        super.drawU(uGraphic.apply(new UTranslate(d, 0.0)));
    }
}

