/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockHorizontal;
import net.sourceforge.plantuml.graphic.TextBlockMarged;
import net.sourceforge.plantuml.graphic.TextBlockMinWidth;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableImpl;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class TextBlockUtils {
    private static final Graphics2D gg;
    private static final StringBounder dummyStringBounder;

    public static TextBlock withMargin(TextBlock textBlock, double d, double d2) {
        return new TextBlockMarged(textBlock, d, d, d2, d2);
    }

    public static TextBlock withMinWidth(TextBlock textBlock, double d, HorizontalAlignment horizontalAlignment) {
        return new TextBlockMinWidth(textBlock, d, horizontalAlignment);
    }

    public static TextBlock withMargin(TextBlock textBlock, double d, double d2, double d3, double d4) {
        return new TextBlockMarged(textBlock, d, d2, d3, d4);
    }

    public static TextBlock empty(final double d, final double d2) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }
        };
    }

    public static Positionable asPositionable(TextBlock textBlock, StringBounder stringBounder, Point2D point2D) {
        return new PositionableImpl(point2D, textBlock.calculateDimension(stringBounder));
    }

    public static TextBlock mergeLR(TextBlock textBlock, TextBlock textBlock2, VerticalAlignment verticalAlignment) {
        return new TextBlockHorizontal(textBlock, textBlock2, verticalAlignment);
    }

    public static TextBlock mergeTB(TextBlock textBlock, TextBlock textBlock2, HorizontalAlignment horizontalAlignment) {
        return new TextBlockVertical2(textBlock, textBlock2, horizontalAlignment);
    }

    public static MinMax getMinMax(TextBlock textBlock, StringBounder stringBounder) {
        LimitFinder limitFinder = new LimitFinder(stringBounder, false);
        textBlock.drawU(limitFinder);
        return limitFinder.getMinMax();
    }

    public static boolean isEmpty(TextBlock textBlock) {
        if (textBlock == null) {
            return true;
        }
        Dimension2D dimension2D = textBlock.calculateDimension(dummyStringBounder);
        return dimension2D.getHeight() == 0.0 && dimension2D.getWidth() == 0.0;
    }

    public static StringBounder getDummyStringBounder() {
        return dummyStringBounder;
    }

    public static FontRenderContext getFontRenderContext() {
        return gg.getFontRenderContext();
    }

    public static MinMax getMinMax(TextBlock textBlock) {
        return TextBlockUtils.getMinMax(textBlock, dummyStringBounder);
    }

    public static Dimension2D getDimension(TextBlock textBlock) {
        return textBlock.calculateDimension(dummyStringBounder);
    }

    public static LineMetrics getLineMetrics(UFont uFont, String string) {
        return uFont.getLineMetrics(gg, string);
    }

    public static FontMetrics getFontMetrics(Font font) {
        return gg.getFontMetrics(font);
    }

    public static TextBlock fullInnerPosition(final TextBlock textBlock, final String string) {
        return new TextBlock(){

            public void drawU(UGraphic uGraphic) {
                textBlock.drawU(uGraphic);
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return textBlock.calculateDimension(stringBounder);
            }

            public Rectangle2D getInnerPosition(String string2, StringBounder stringBounder) {
                if (string.startsWith(string2)) {
                    Dimension2D dimension2D = this.calculateDimension(stringBounder);
                    return new Rectangle2D.Double(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight());
                }
                return null;
            }
        };
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        gg = bufferedImage.createGraphics();
        dummyStringBounder = StringBounderUtils.asStringBounder(gg);
    }
}

