/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBlockVertical2
extends AbstractTextBlock
implements TextBlock {
    private final List<TextBlock> blocks = new ArrayList<TextBlock>();
    private final HorizontalAlignment horizontalAlignment;

    public TextBlockVertical2(TextBlock textBlock, TextBlock textBlock2, HorizontalAlignment horizontalAlignment) {
        this.blocks.add(textBlock);
        this.blocks.add(textBlock2);
        this.horizontalAlignment = horizontalAlignment;
    }

    public TextBlockVertical2(List<TextBlock> list, HorizontalAlignment horizontalAlignment) {
        if (list.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.blocks.addAll(list);
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.blocks.get(0).calculateDimension(stringBounder);
        for (int i = 1; i < this.blocks.size(); ++i) {
            dimension2D = Dimension2DDouble.mergeTB(dimension2D, this.blocks.get(i).calculateDimension(stringBounder));
        }
        return dimension2D;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        double d = 0.0;
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        for (TextBlock textBlock : this.blocks) {
            double d2;
            Dimension2D dimension2D2 = textBlock.calculateDimension(uGraphic.getStringBounder());
            if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
                textBlock.drawU(uGraphic.apply(new UTranslate(0.0, d)));
            } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
                d2 = (dimension2D.getWidth() - dimension2D2.getWidth()) / 2.0;
                textBlock.drawU(uGraphic.apply(new UTranslate(d2, d)));
            } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
                d2 = dimension2D.getWidth() - dimension2D2.getWidth();
                textBlock.drawU(uGraphic.apply(new UTranslate(d2, d)));
            } else {
                throw new UnsupportedOperationException();
            }
            d += dimension2D2.getHeight();
        }
    }

    @Override
    public Rectangle2D getInnerPosition(String string, StringBounder stringBounder) {
        double d = 0.0;
        for (TextBlock textBlock : this.blocks) {
            Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
            Rectangle2D rectangle2D = textBlock.getInnerPosition(string, stringBounder);
            if (rectangle2D != null) {
                return new UTranslate(0.0, d).apply(rectangle2D);
            }
            d += dimension2D.getHeight();
        }
        return null;
    }
}

