/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class USymbolFolder
extends USymbol {
    private static final int marginTitleX1 = 3;
    private static final int marginTitleX2 = 3;
    private static final int marginTitleX3 = 7;
    private static final int marginTitleY0 = 0;
    private static final int marginTitleY1 = 3;
    private static final int marginTitleY2 = 3;
    private final SkinParameter skinParameter;

    public USymbolFolder(SkinParameter skinParameter) {
        this.skinParameter = skinParameter;
    }

    public SkinParameter getSkinParameter() {
        return this.skinParameter;
    }

    private void drawFolder(UGraphic uGraphic, double d, double d2, Dimension2D dimension2D, boolean bl) {
        double d3 = dimension2D.getWidth() == 0.0 ? Math.max(30.0, d / 4.0) : dimension2D.getWidth() + 3.0 + 3.0;
        double d4 = this.getHTitle(dimension2D);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(d3, 0.0);
        uPolygon.addPoint(d3 + 7.0, d4);
        uPolygon.addPoint(d, d4);
        uPolygon.addPoint(d, d2);
        uPolygon.addPoint(0.0, d2);
        uPolygon.addPoint(0.0, 0.0);
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        uGraphic.draw(uPolygon);
        uGraphic.apply(new UTranslate(0.0, d4)).draw(new ULine(d3 + 7.0, 0.0));
    }

    private double getHTitle(Dimension2D dimension2D) {
        double d = dimension2D.getWidth() == 0.0 ? 10.0 : dimension2D.getHeight() + 3.0 + 3.0;
        return d;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 20.0, 13.0, 10.0);
    }

    public TextBlock asSmall(final TextBlock textBlock, final TextBlock textBlock2, final TextBlock textBlock3, final SymbolContext symbolContext) {
        if (textBlock == null) {
            throw new IllegalArgumentException();
        }
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                Dimension2D dimension2D2 = textBlock.calculateDimension(uGraphic.getStringBounder());
                USymbolFolder.this.drawFolder(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), dimension2D2, symbolContext.isShadowing());
                USymbol.Margin margin = USymbolFolder.this.getMargin();
                TextBlock textBlock4 = TextBlockUtils.mergeTB(textBlock3, textBlock2, HorizontalAlignment.CENTER);
                textBlock.drawU(uGraphic.apply(new UTranslate(4.0, 3.0)));
                textBlock4.drawU(uGraphic.apply(new UTranslate(margin.getX1(), margin.getY1() + dimension2D2.getHeight())));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock2.calculateDimension(stringBounder);
                Dimension2D dimension2D3 = textBlock3.calculateDimension(stringBounder);
                return USymbolFolder.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D, dimension2D3, dimension2D2));
            }
        };
    }

    public TextBlock asBig(final TextBlock textBlock, final TextBlock textBlock2, final double d, final double d2, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                StringBounder stringBounder = uGraphic.getStringBounder();
                Dimension2D dimension2D = this.calculateDimension(stringBounder);
                uGraphic = symbolContext.apply(uGraphic);
                Dimension2D dimension2D2 = textBlock.calculateDimension(stringBounder);
                USymbolFolder.this.drawFolder(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), dimension2D2, symbolContext.isShadowing());
                textBlock.drawU(uGraphic.apply(new UTranslate(4.0, 2.0)));
                Dimension2D dimension2D3 = textBlock2.calculateDimension(stringBounder);
                double d3 = (d - dimension2D3.getWidth()) / 2.0;
                textBlock2.drawU(uGraphic.apply(new UTranslate(4.0 + d3, 2.0 + USymbolFolder.this.getHTitle(dimension2D2))));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }
        };
    }
}

