/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jungle;

import java.util.List;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.jungle.GNode;
import net.sourceforge.plantuml.jungle.GTileNode;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Needle
implements UDrawable {
    private final double length;
    private final Display display;
    private final double degreePosition;
    private final double degreeOperture;

    private Needle(Display display, double d, double d2, double d3) {
        this.display = display;
        this.degreePosition = d2;
        this.degreeOperture = d3;
        this.length = d;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        GTileNode.getTextBlock(this.display);
        uGraphic.draw(this.getLine());
        uGraphic = uGraphic.apply(this.getTranslate(this.length));
        GTileNode.getTextBlock(this.display).drawU(uGraphic);
    }

    private ULine getLine() {
        UTranslate uTranslate = this.getTranslate(this.length);
        return new ULine(uTranslate.getDx(), uTranslate.getDy());
    }

    public UTranslate getTranslate(double d) {
        double d2 = this.degreePosition * Math.PI / 180.0;
        double d3 = d * Math.cos(d2);
        double d4 = d * Math.sin(d2);
        return new UTranslate(d3, d4);
    }

    public UDrawable addChildren(final List<GNode> list) {
        return new UDrawable(){

            public void drawU(UGraphic uGraphic) {
                Needle.this.drawU(uGraphic);
                if (list.size() == 0) {
                    return;
                }
                uGraphic = uGraphic.apply(Needle.this.getTranslate(Needle.this.length / 2.0));
                UDrawable uDrawable = Needle.getNeedle((GNode)list.get(0), Needle.this.length / 2.0, Needle.this.degreePosition + Needle.this.degreeOperture, Needle.this.degreeOperture / 2.0);
                uDrawable.drawU(uGraphic);
                if (list.size() == 1) {
                    return;
                }
                UDrawable uDrawable2 = Needle.getNeedle((GNode)list.get(1), Needle.this.length / 2.0, Needle.this.degreePosition - Needle.this.degreeOperture, Needle.this.degreeOperture / 2.0);
                uDrawable2.drawU(uGraphic);
            }
        };
    }

    public static UDrawable getNeedle(GNode gNode, double d, double d2, double d3) {
        Needle needle = new Needle(gNode.getDisplay(), d, d2, d3);
        final UDrawable uDrawable = needle.addChildren(gNode.getChildren());
        return new UDrawable(){

            public void drawU(UGraphic uGraphic) {
                uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
                uDrawable.drawU(uGraphic);
            }
        };
    }
}

