/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.postit;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.postit.Area;
import net.sourceforge.plantuml.postit.PostIt;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

public class PostItDiagram
extends UmlDiagram {
    private final Area defaultArea = new Area('\u0000', null);
    private final Map<String, PostIt> postIts = new HashMap<String, PostIt>();
    private int width = 800;

    public UmlDiagramType getUmlDiagramType() {
        return null;
    }

    protected final ImageData exportDiagramInternal(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        UGraphic uGraphic = this.createImage(fileFormatOption);
        this.drawU(uGraphic);
        if (uGraphic instanceof UGraphicG2d) {
            BufferedImage bufferedImage = ((UGraphicG2d)uGraphic).getBufferedImage();
            PngIO.write((RenderedImage)bufferedImage, outputStream, fileFormatOption.isWithMetadata() ? this.getMetadata() : null, this.getDpi(fileFormatOption));
        } else if (uGraphic instanceof UGraphicSvg) {
            UGraphicSvg uGraphicSvg = (UGraphicSvg)uGraphic;
            uGraphicSvg.createXml(outputStream);
        } else if (uGraphic instanceof UGraphicEps) {
            UGraphicEps uGraphicEps = (UGraphicEps)uGraphic;
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        }
        return new ImageDataSimple();
    }

    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("Board of post-it", this.getClass());
    }

    public Area getDefaultArea() {
        return this.defaultArea;
    }

    public Area createArea(char c) {
        throw new UnsupportedOperationException();
    }

    public PostIt createPostIt(String string, Display display) {
        if (this.postIts.containsKey(string)) {
            throw new IllegalArgumentException();
        }
        PostIt postIt = new PostIt(string, display);
        this.postIts.put(string, postIt);
        this.getDefaultArea().add(postIt);
        return postIt;
    }

    void drawU(UGraphic uGraphic) {
        this.getDefaultArea().drawU(uGraphic, this.width);
    }

    private UGraphic createImage(FileFormatOption fileFormatOption) {
        Color color = this.getSkinParam().getColorMapper().getMappedColor(this.getSkinParam().getBackgroundColor());
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            double d = this.getDefaultArea().heightWhenWidthIs(this.width, TextBlockUtils.getDummyStringBounder());
            EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder((double)this.width, d, color);
            Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
            double d2 = this.getDpiFactor(fileFormatOption);
            UGraphicG2d uGraphicG2d = new UGraphicG2d(new ColorMapperIdentity(), graphics2D, d2);
            uGraphicG2d.setBufferedImage(emptyImageBuilder.getBufferedImage());
            return uGraphicG2d;
        }
        throw new UnsupportedOperationException();
    }

    public void setWidth(int n) {
        this.width = n;
    }
}

