/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.IfManager;
import net.sourceforge.plantuml.preproc.PreprocessorInclude;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineInsertable;
import net.sourceforge.plantuml.utils.StartUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preprocessor
implements ReadLine {
    private static final String ID = "[A-Za-z_][A-Za-z_0-9]*";
    private static final String ARG = "(?:\\([A-Za-z_][A-Za-z_0-9]*(?:,[A-Za-z_][A-Za-z_0-9]*)*?\\))?";
    private static final Pattern definePattern = MyPattern.cmpile("^[%s]*!define[%s]+([A-Za-z_][A-Za-z_0-9]*(?:\\([A-Za-z_][A-Za-z_0-9]*(?:,[A-Za-z_][A-Za-z_0-9]*)*?\\))?)(?:[%s]+(.*))?$");
    private static final Pattern undefPattern = MyPattern.cmpile("^[%s]*!undef[%s]+([A-Za-z_][A-Za-z_0-9]*)$");
    private static final Pattern definelongPattern = MyPattern.cmpile("^[%s]*!definelong[%s]+([A-Za-z_][A-Za-z_0-9]*(?:\\([A-Za-z_][A-Za-z_0-9]*(?:,[A-Za-z_][A-Za-z_0-9]*)*?\\))?)");
    private static final Pattern enddefinelongPattern = MyPattern.cmpile("^[%s]*!enddefinelong[%s]*$");
    private final Defines defines;
    private final PreprocessorInclude rawSource;
    private final ReadLineInsertable source;
    private int ignoreDefineDuringSeveralLines = 0;

    public Preprocessor(ReadLine readLine, String string, Defines defines, File file) {
        this.defines = defines;
        this.defines.saveState();
        this.rawSource = new PreprocessorInclude(readLine, defines, string, file);
        this.source = new ReadLineInsertable(new IfManager(this.rawSource, defines));
    }

    @Override
    public CharSequence2 readLine() throws IOException {
        Matcher matcher;
        CharSequence2 charSequence2 = this.source.readLine();
        if (charSequence2 == null) {
            return null;
        }
        if (StartUtils.isArobaseStartDiagram(charSequence2)) {
            this.defines.restoreState();
        }
        if ((matcher = definePattern.matcher(charSequence2)).find()) {
            return this.manageDefine(matcher);
        }
        matcher = definelongPattern.matcher(charSequence2);
        if (matcher.find()) {
            return this.manageDefineLong(matcher);
        }
        matcher = undefPattern.matcher(charSequence2);
        if (matcher.find()) {
            return this.manageUndef(matcher);
        }
        if (this.ignoreDefineDuringSeveralLines > 0) {
            --this.ignoreDefineDuringSeveralLines;
            return charSequence2;
        }
        List<String> list = this.defines.applyDefines(charSequence2.toString2());
        if (list.size() > 1) {
            this.ignoreDefineDuringSeveralLines = list.size() - 2;
            this.source.insert(list.subList(1, list.size() - 1), charSequence2.getLocation());
        }
        return new CharSequence2Impl(list.get(0), charSequence2.getLocation());
    }

    private CharSequence2 manageUndef(Matcher matcher) throws IOException {
        this.defines.undefine(matcher.group(1));
        return this.readLine();
    }

    private CharSequence2 manageDefineLong(Matcher matcher) throws IOException {
        CharSequence2 charSequence2;
        String string = matcher.group(1);
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            if ((charSequence2 = this.readLine()) == null) {
                return null;
            }
            arrayList.add(charSequence2.toString2());
        } while (!enddefinelongPattern.matcher(charSequence2).find());
        this.defines.define(string, arrayList);
        return this.readLine();
    }

    private CharSequence2 manageDefine(Matcher matcher) throws IOException {
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        if (string2 == null) {
            this.defines.define(string, null);
        } else {
            List<String> list = this.defines.applyDefines(string2);
            if (list.size() > 1) {
                this.defines.define(string, list);
            } else {
                Object object;
                StringBuilder stringBuilder = new StringBuilder(list.get(0));
                while (StringUtils.endsWithBackslash(stringBuilder.toString())) {
                    stringBuilder.setLength(stringBuilder.length() - 1);
                    object = this.readLine();
                    stringBuilder.append(object.toString2());
                }
                object = new ArrayList<String>();
                object.add(stringBuilder.toString());
                this.defines.define(string, (List<String>)object);
            }
        }
        return this.readLine();
    }

    public int getLineNumber() {
        return this.rawSource.getLineNumber();
    }

    @Override
    public void close() throws IOException {
        this.rawSource.close();
    }

    public Set<FileWithSuffix> getFilesUsed() {
        return Collections.unmodifiableSet(this.rawSource.getFilesUsedGlobal());
    }
}

