/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.element.AbstractElement;
import net.sourceforge.plantuml.salt.element.ElementMenuEntry;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementMenuPopup
extends AbstractElement {
    private final Collection<ElementMenuEntry> entries = new ArrayList<ElementMenuEntry>();
    private final UFont font;
    private final ISkinSimple spriteContainer;

    public ElementMenuPopup(UFont uFont, ISkinSimple iSkinSimple) {
        this.font = uFont;
        this.spriteContainer = iSkinSimple;
    }

    public void addEntry(String string) {
        this.entries.add(new ElementMenuEntry(string, this.font, this.spriteContainer));
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (ElementMenuEntry elementMenuEntry : this.entries) {
            Dimension2D dimension2D = elementMenuEntry.getPreferredDimension(stringBounder, d, d2);
            d3 = Math.max(d3, dimension2D.getWidth());
            d4 += dimension2D.getHeight();
        }
        return new Dimension2DDouble(d3, d4);
    }

    public void drawU(UGraphic uGraphic, int n, Dimension2D dimension2D) {
        if (n != 1) {
            return;
        }
        uGraphic.apply(new UChangeBackColor(HtmlColorSet.getInstance().getColorIfValid("#DDDDDD"))).draw(new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
        double d = 0.0;
        for (ElementMenuEntry elementMenuEntry : this.entries) {
            double d2 = elementMenuEntry.getPreferredDimension(uGraphic.getStringBounder(), 0.0, d).getHeight();
            if (elementMenuEntry.getText().equals("-")) {
                uGraphic.apply(new UTranslate(0.0, d + d2 / 2.0)).draw(new ULine(dimension2D.getWidth(), 0.0));
            } else {
                elementMenuEntry.drawU(uGraphic.apply(new UTranslate(0.0, d)), n, dimension2D);
            }
            d += d2;
        }
    }
}

