/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Participant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reference
extends AbstractEvent
implements Event {
    private final List<Participant> participants;
    private final Url url;
    private final HtmlColor backColorGeneral;
    private final HtmlColor backColorElement;
    private final Display strings;

    public Reference(List<Participant> list, Url url, Display display, HtmlColor htmlColor, HtmlColor htmlColor2) {
        this.participants = list;
        this.url = url;
        this.strings = display;
        this.backColorGeneral = htmlColor;
        this.backColorElement = htmlColor2;
    }

    public List<Participant> getParticipant() {
        return Collections.unmodifiableList(this.participants);
    }

    public Display getStrings() {
        return this.strings;
    }

    @Override
    public boolean dealWith(Participant participant) {
        return this.participants.contains(participant);
    }

    @Override
    public final Url getUrl() {
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        return this.url != null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Participant> iterator = this.participants.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().getCode());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    public final HtmlColor getBackColorGeneral() {
        return this.backColorGeneral;
    }

    public final HtmlColor getBackColorElement() {
        return this.backColorElement;
    }
}

