/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.command.CommandArrow;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CommandExoArrowAny
extends SingleLineCommand2<SequenceDiagram> {
    public CommandExoArrowAny(RegexConcat regexConcat) {
        super(regexConcat);
    }

    @Override
    protected final CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
        String string;
        ArrowConfiguration arrowConfiguration;
        String string2 = regexResult.getLazzy("ARROW_BODYA", 0) + regexResult.getLazzy("ARROW_BODYB", 0);
        String string3 = regexResult.getLazzy("ARROW_DRESSING", 0);
        Participant participant = sequenceDiagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("PARTICIPANT", 0)));
        boolean bl = string3.length() == 2;
        boolean bl2 = string2.contains("--");
        Display display = regexResult.get("LABEL", 0) == null ? Display.create("") : Display.getWithNewlines(regexResult.get("LABEL", 0));
        boolean bl3 = regexResult.get("ARROW_BOTHDRESSING", 0) != null;
        ArrowConfiguration arrowConfiguration2 = arrowConfiguration = bl3 ? ArrowConfiguration.withDirectionBoth() : ArrowConfiguration.withDirectionNormal();
        if (bl2) {
            arrowConfiguration = arrowConfiguration.withDotted();
        }
        if (bl) {
            arrowConfiguration = arrowConfiguration.withHead(ArrowHead.ASYNC);
        }
        arrowConfiguration = arrowConfiguration.withPart(this.getArrowPart(string3));
        arrowConfiguration = CommandArrow.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), arrowConfiguration);
        MessageExoType messageExoType = this.getMessageExoType(regexResult);
        if (messageExoType == MessageExoType.TO_RIGHT || messageExoType == MessageExoType.TO_LEFT) {
            if (this.containsSymbolExterior(regexResult, "o")) {
                arrowConfiguration = arrowConfiguration.withDecoration2(ArrowDecoration.CIRCLE);
            }
            if (this.containsSymbol(regexResult, "o")) {
                arrowConfiguration = arrowConfiguration.withDecoration1(ArrowDecoration.CIRCLE);
            }
        } else {
            if (this.containsSymbolExterior(regexResult, "o")) {
                arrowConfiguration = arrowConfiguration.withDecoration1(ArrowDecoration.CIRCLE);
            }
            if (this.containsSymbol(regexResult, "o")) {
                arrowConfiguration = arrowConfiguration.withDecoration2(ArrowDecoration.CIRCLE);
            }
        }
        if (this.containsSymbolExterior(regexResult, "x") || this.containsSymbol(regexResult, "x")) {
            arrowConfiguration = arrowConfiguration.withHead2(ArrowHead.CROSSX);
        }
        if ((string = sequenceDiagram.addMessage(new MessageExo(participant, messageExoType, display, arrowConfiguration, sequenceDiagram.getNextMessageNumber(), this.isShortArrow(regexResult)))) != null) {
            return CommandExecutionResult.error(string);
        }
        HtmlColor htmlColor = sequenceDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("LIFECOLOR", 0));
        if (sequenceDiagram.isAutoactivate() && (arrowConfiguration.getHead() == ArrowHead.NORMAL || arrowConfiguration.getHead() == ArrowHead.ASYNC)) {
            if (arrowConfiguration.isDotted()) {
                sequenceDiagram.activate(participant, LifeEventType.DEACTIVATE, null);
            } else {
                sequenceDiagram.activate(participant, LifeEventType.ACTIVATE, htmlColor);
            }
        }
        return CommandExecutionResult.ok();
    }

    private ArrowPart getArrowPart(String string) {
        if (string.contains("/")) {
            return ArrowPart.BOTTOM_PART;
        }
        if (string.contains("\\")) {
            return ArrowPart.TOP_PART;
        }
        return ArrowPart.FULL;
    }

    abstract MessageExoType getMessageExoType(RegexResult var1);

    private boolean isShortArrow(RegexResult regexResult) {
        String string = regexResult.get("SHORT", 0);
        return string != null && string.contains("?");
    }

    private boolean containsSymbolExterior(RegexResult regexResult, String string) {
        String string2 = regexResult.get("SHORT", 0);
        return string2 != null && string2.contains(string);
    }

    private boolean containsSymbol(RegexResult regexResult, String string) {
        String string2 = regexResult.get("ARROW_SUPPCIRCLE", 0);
        return string2 != null && string2.contains(string);
    }
}

