/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Englober;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class Englobers {
    private final List<Englober> englobers = new ArrayList<Englober>();

    public Englobers(TileArguments tileArguments) {
        Englober englober = null;
        for (Participant participant : tileArguments.getLivingSpaces().participants()) {
            ParticipantEnglober participantEnglober = tileArguments.getLivingSpaces().get(participant).getEnglober();
            if (participantEnglober == null) {
                englober = null;
                continue;
            }
            assert (participantEnglober != null);
            if (englober != null && participantEnglober == englober.getParticipantEnglober()) {
                englober.add(participant);
                continue;
            }
            englober = new Englober(participantEnglober, participant, tileArguments);
            this.englobers.add(englober);
        }
    }

    public int size() {
        return this.englobers.size();
    }

    public double getOffsetForEnglobers(StringBounder stringBounder) {
        double d = 0.0;
        for (Englober englober : this.englobers) {
            double d2 = englober.getPreferredHeight();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public void addConstraints(StringBounder stringBounder) {
        Englober englober = null;
        for (Englober englober2 : this.englobers) {
            englober2.addInternalConstraints();
            if (englober != null) {
                englober.addConstraintAfter(englober2);
            }
            englober = englober2;
        }
    }

    public void drawEnglobers(UGraphic uGraphic, double d, Context2D context2D) {
        for (Englober englober : this.englobers) {
            englober.drawEnglober(uGraphic, d, context2D);
        }
    }

    public Real getMinX(StringBounder stringBounder) {
        if (this.size() == 0) {
            throw new IllegalStateException();
        }
        ArrayList<Real> arrayList = new ArrayList<Real>();
        for (Englober englober : this.englobers) {
            arrayList.add(englober.getMinX(stringBounder));
        }
        return RealUtils.min(arrayList);
    }

    public Real getMaxX(StringBounder stringBounder) {
        if (this.size() == 0) {
            throw new IllegalStateException();
        }
        ArrayList<Real> arrayList = new ArrayList<Real>();
        for (Englober englober : this.englobers) {
            arrayList.add(englober.getMaxX(stringBounder));
        }
        return RealUtils.max(arrayList);
    }
}

