/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LifeEventTile
implements TileWithUpdateStairs {
    private final LifeEvent lifeEvent;
    private final TileArguments tileArguments;
    private final LivingSpace livingSpace;
    private final Skin skin;
    private final ISkinParam skinParam;

    public void updateStairs(StringBounder stringBounder, double d) {
        System.err.println("LifeEventTile::updateStairs " + this.lifeEvent + " " + this.livingSpace.getParticipant() + " y=" + d);
        this.livingSpace.addStepForLivebox(this.getEvent(), d);
    }

    public Event getEvent() {
        return this.lifeEvent;
    }

    public LifeEventTile(LifeEvent lifeEvent, TileArguments tileArguments, LivingSpace livingSpace, Skin skin, ISkinParam iSkinParam) {
        this.lifeEvent = lifeEvent;
        this.tileArguments = tileArguments;
        this.livingSpace = livingSpace;
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    public void drawU(UGraphic uGraphic) {
        if (this.isDestroyWithoutMessage()) {
            Component component = this.skin.createComponent(ComponentType.DESTROY, null, this.skinParam, null);
            Dimension2D dimension2D = component.getPreferredDimension(uGraphic.getStringBounder());
            double d = this.livingSpace.getPosC(uGraphic.getStringBounder()).getCurrentValue();
            component.drawU(uGraphic.apply(new UTranslate(d - dimension2D.getWidth() / 2.0, 0.0)), null, (Context2D)((Object)uGraphic));
        }
    }

    public boolean isDestroyWithoutMessage() {
        return this.lifeEvent.getMessage() == null && this.lifeEvent.getType() == LifeEventType.DESTROY;
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        if (this.isDestroyWithoutMessage()) {
            Component component = this.skin.createComponent(ComponentType.DESTROY, null, this.skinParam, null);
            Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
            return dimension2D.getHeight();
        }
        return 0.0;
    }

    public void addConstraints(StringBounder stringBounder) {
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.livingSpace.getPosB();
    }

    public Real getMaxX(StringBounder stringBounder) {
        return RealUtils.max(this.livingSpace.getPosD(stringBounder), this.livingSpace.getPosC2(stringBounder));
    }
}

