/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistory;
import net.sourceforge.plantuml.sequencediagram.teoz.IntegerColored;
import net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxesDrawer;
import net.sourceforge.plantuml.sequencediagram.teoz.Stairs2;
import net.sourceforge.plantuml.sequencediagram.teoz.StairsPosition;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LiveBoxes {
    private final EventsHistory eventsHistory;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final Map<Double, Double> delays = new TreeMap<Double, Double>();

    public LiveBoxes(EventsHistory eventsHistory, Skin skin, ISkinParam iSkinParam, Participant participant) {
        this.eventsHistory = eventsHistory;
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    public double getMaxPosition(StringBounder stringBounder) {
        int n = this.eventsHistory.getMaxValue();
        LiveBoxesDrawer liveBoxesDrawer = new LiveBoxesDrawer(new SimpleContext2D(true), this.skin, this.skinParam, this.delays);
        return liveBoxesDrawer.getWidth(stringBounder) / 2.0 * (double)n;
    }

    public void drawBoxes(UGraphic uGraphic, Context2D context2D, double d, double d2) {
        Stairs2 stairs2 = this.eventsHistory.getStairs(d, d2);
        int n = stairs2.getMaxValue();
        if (n == 0) {
            this.drawDestroys(uGraphic, stairs2, context2D);
        }
        for (int i = 1; i <= n; ++i) {
            this.drawOneLevel(uGraphic, i, stairs2, context2D);
        }
    }

    private void drawDestroys(UGraphic uGraphic, Stairs2 stairs2, Context2D context2D) {
        LiveBoxesDrawer liveBoxesDrawer = new LiveBoxesDrawer(context2D, this.skin, this.skinParam, this.delays);
        for (StairsPosition stairsPosition : stairs2.getYs()) {
            liveBoxesDrawer.drawDestroyIfNeeded(uGraphic, stairsPosition);
        }
    }

    private void drawOneLevel(UGraphic uGraphic, int n, Stairs2 stairs2, Context2D context2D) {
        LiveBoxesDrawer liveBoxesDrawer = new LiveBoxesDrawer(context2D, this.skin, this.skinParam, this.delays);
        uGraphic = uGraphic.apply(new UTranslate((double)(n - 1) * liveBoxesDrawer.getWidth(uGraphic.getStringBounder()) / 2.0, 0.0));
        boolean bl = true;
        Iterator<StairsPosition> iterator = stairs2.getYs().iterator();
        while (iterator.hasNext()) {
            StairsPosition stairsPosition = iterator.next();
            IntegerColored integerColored = stairs2.getValue(stairsPosition.getValue());
            int n2 = integerColored.getValue();
            if (bl && n2 == n) {
                liveBoxesDrawer.addStart(stairsPosition.getValue(), integerColored.getColors());
                bl = false;
                continue;
            }
            if (bl || iterator.hasNext() && n2 >= n) continue;
            liveBoxesDrawer.doDrawing(uGraphic, stairsPosition);
            liveBoxesDrawer.drawDestroyIfNeeded(uGraphic, stairsPosition);
            bl = true;
        }
    }

    public void delayOn(double d, double d2) {
        this.delays.put(d, d2);
    }
}

