/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sudoku;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.sudoku.ISudoku;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

public class GraphicsSudoku {
    private final ISudoku sudoku;
    private final UFont numberFont = new UFont("SansSerif", 1, 20);
    private final UFont font = new UFont("SansSerif", 0, 11);
    private final int xOffset = 5;
    private final int yOffset = 5;
    private final int cellWidth = 30;
    private final int cellHeight = 32;
    private final int numberxOffset = 10;
    private final int numberyOffset = 5;
    private final int textTotalHeight = 50;

    public GraphicsSudoku(ISudoku iSudoku) {
        this.sudoku = iSudoku;
    }

    public ImageData writeImage(OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = this.createImage();
        PngIO.write((RenderedImage)bufferedImage, outputStream, 96);
        return new ImageDataSimple(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    private BufferedImage createImage() {
        int n;
        int n2;
        int n3;
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(283, 351, Color.WHITE);
        BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphic uGraphic = new UGraphicG2d(new ColorMapperIdentity(), graphics2D, 1.0);
        uGraphic = uGraphic.apply(new UTranslate(5.0, 5.0));
        for (n3 = 0; n3 < 9; ++n3) {
            for (n2 = 0; n2 < 9; ++n2) {
                n = this.sudoku.getGiven(n3, n2);
                if (n <= 0) continue;
                TextBlock textBlock = Display.create("" + n).create(FontConfiguration.blackBlueTrue(this.numberFont), HorizontalAlignment.CENTER, new SpriteContainerEmpty());
                textBlock.drawU(uGraphic.apply(new UTranslate(10 + n3 * 30, 5 + n2 * 32)));
            }
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(HtmlColorUtils.BLACK)).apply(new UChangeColor(null));
        for (n3 = 0; n3 < 10; ++n3) {
            n2 = n3 % 3 == 0 ? 1 : 0;
            n = n2 != 0 ? 3 : 1;
            uGraphic.apply(new UTranslate(0.0, n3 * 32)).draw(new URectangle(273.0, n));
        }
        for (n3 = 0; n3 < 10; ++n3) {
            n2 = n3 % 3 == 0 ? 1 : 0;
            n = n2 != 0 ? 3 : 1;
            uGraphic.apply(new UTranslate(n3 * 30, 0.0)).draw(new URectangle(n, 291.0));
        }
        uGraphic = uGraphic.apply(new UTranslate(0.0, 301.0));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("http://plantuml.sourceforge.net");
        arrayList.add("Seed " + Long.toString(this.sudoku.getSeed(), 36));
        arrayList.add("Difficulty " + this.sudoku.getRatting());
        TextBlock textBlock = Display.create(arrayList).create(FontConfiguration.blackBlueTrue(this.font), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        textBlock.drawU(uGraphic);
        graphics2D.dispose();
        return bufferedImage;
    }
}

