/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.EnumSet;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PackageStyle {
    FOLDER,
    RECT,
    NODE,
    FRAME,
    CLOUD,
    DATABASE,
    AGENT,
    STORAGE,
    COMPONENT1,
    COMPONENT2,
    ARTIFACT,
    CARD;


    public static PackageStyle fromString(String string) {
        for (PackageStyle packageStyle : EnumSet.allOf(PackageStyle.class)) {
            if (!packageStyle.toString().equalsIgnoreCase(string)) continue;
            return packageStyle;
        }
        return null;
    }

    public USymbol toUSymbol() {
        if (this == NODE) {
            return USymbol.NODE;
        }
        if (this == CARD) {
            return USymbol.CARD;
        }
        if (this == DATABASE) {
            return USymbol.DATABASE;
        }
        if (this == CLOUD) {
            return USymbol.CLOUD;
        }
        if (this == FRAME) {
            return USymbol.FRAME;
        }
        if (this == RECT) {
            return USymbol.RECTANGLE;
        }
        if (this == FOLDER) {
            return USymbol.FOLDER;
        }
        return null;
    }

    public void drawU(UGraphic uGraphic, Dimension2D dimension2D, Dimension2D dimension2D2, boolean bl) {
        if (dimension2D2 == null) {
            dimension2D2 = new Dimension2DDouble(0.0, 0.0);
        }
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        if (this == DATABASE) {
            this.drawDatabase(uGraphic, d, d2, bl);
        } else if (this == FOLDER) {
            this.drawFolder(uGraphic, d, d2, bl);
        } else if (this == FRAME) {
            this.drawFrame(uGraphic, d, d2, dimension2D2, bl);
        } else if (this == CLOUD) {
            this.drawCloud(uGraphic, d, d2, bl);
        } else if (this == RECT) {
            this.drawRect(uGraphic, d, d2, bl);
        } else if (this == COMPONENT1) {
            this.drawComponent1(uGraphic, d, d2, bl);
        } else if (this == COMPONENT2) {
            this.drawComponent2(uGraphic, d, d2, bl);
        } else if (this == STORAGE) {
            this.drawStorage(uGraphic, d, d2, bl);
        } else if (this == AGENT) {
            this.drawRect(uGraphic, d, d2, bl);
        } else if (this == ARTIFACT) {
            this.drawArtifact(uGraphic, d, d2, bl);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void drawArtifact(UGraphic uGraphic, double d, double d2, boolean bl) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, d2);
        uPolygon.addPoint(d, d2);
        uPolygon.addPoint(d, 10.0);
        uPolygon.addPoint(d - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        uGraphic.draw(uPolygon);
        uGraphic.apply(new UTranslate(d - 10.0, 0.0)).draw(new ULine(0.0, 10.0));
        uGraphic.apply(new UTranslate(d, 10.0)).draw(new ULine(-10.0, 0.0));
    }

    private void drawStorage(UGraphic uGraphic, double d, double d2, boolean bl) {
        URectangle uRectangle = new URectangle(d, d2, 70.0, 70.0);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.draw(uRectangle);
    }

    private void drawComponent1(UGraphic uGraphic, double d, double d2, boolean bl) {
        URectangle uRectangle = new URectangle(d, d2);
        if (bl) {
            uRectangle.setDeltaShadow(4.0);
        }
        URectangle uRectangle2 = new URectangle(10.0, 5.0);
        uGraphic.draw(uRectangle);
        uGraphic.apply(new UTranslate(-5.0, 5.0)).draw(uRectangle2);
        uGraphic.apply(new UTranslate(-5.0, d2 - 10.0)).draw(uRectangle2);
    }

    private void drawComponent2(UGraphic uGraphic, double d, double d2, boolean bl) {
        URectangle uRectangle = new URectangle(d, d2);
        if (bl) {
            uRectangle.setDeltaShadow(4.0);
        }
        URectangle uRectangle2 = new URectangle(15.0, 10.0);
        URectangle uRectangle3 = new URectangle(4.0, 2.0);
        uGraphic.draw(uRectangle);
        uGraphic.apply(new UTranslate(d - 20.0, 5.0)).draw(uRectangle2);
        uGraphic.apply(new UTranslate(d - 22.0, 7.0)).draw(uRectangle3);
        uGraphic.apply(new UTranslate(d - 22.0, 11.0)).draw(uRectangle3);
    }

    private void drawRect(UGraphic uGraphic, double d, double d2, boolean bl) {
        URectangle uRectangle = new URectangle(d, d2);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.draw(uRectangle);
    }

    private void drawCloud(UGraphic uGraphic, double d, double d2, boolean bl) {
        UPath uPath = this.getSpecificFrontierForCloud(d, d2);
        if (bl) {
            uPath.setDeltaShadow(3.0);
        }
        uGraphic.apply(new UTranslate(3.0, -3.0)).draw(uPath);
    }

    private UPath getSpecificFrontierForCloud(double d, double d2) {
        UPath uPath = new UPath();
        uPath.moveTo(0.0, 10.0);
        double d3 = 0.0;
        int n = 0;
        while ((double)n < d - 9.0) {
            uPath.cubicTo(n, 7.0, 2 + n, 5.0, 5 + n, 5.0);
            uPath.cubicTo(8 + n, 5.0, 10 + n, 7.0, 10 + n, 10.0);
            d3 = n + 10;
            n += 10;
        }
        double d4 = 0.0;
        int n2 = 10;
        while ((double)n2 < d2 - 9.0) {
            uPath.cubicTo(d3 + 3.0, n2, d3 + 5.0, 2 + n2, d3 + 5.0, 5 + n2);
            uPath.cubicTo(d3 + 5.0, 8 + n2, d3 + 3.0, 10 + n2, d3, 10 + n2);
            d4 = n2 + 10;
            n2 += 10;
        }
        n2 = 0;
        while ((double)n2 < d - 9.0) {
            uPath.cubicTo(d3 - (double)n2, d4 + 3.0, d3 - 3.0 - (double)n2, d4 + 5.0, d3 - 5.0 - (double)n2, d4 + 5.0);
            uPath.cubicTo(d3 - 8.0 - (double)n2, d4 + 5.0, d3 - 10.0 - (double)n2, d4 + 3.0, d3 - 10.0 - (double)n2, d4);
            n2 += 10;
        }
        n2 = 0;
        while ((double)n2 < d2 - 9.0 - 10.0) {
            uPath.cubicTo(-3.0, d4 - (double)n2, -5.0, d4 - 2.0 - (double)n2, -5.0, d4 - 5.0 - (double)n2);
            uPath.cubicTo(-5.0, d4 - 8.0 - (double)n2, -3.0, d4 - 10.0 - (double)n2, 0.0, d4 - 10.0 - (double)n2);
            n2 += 10;
        }
        return uPath;
    }

    private void drawFrame(UGraphic uGraphic, double d, double d2, Dimension2D dimension2D, boolean bl) {
        int n;
        double d3;
        double d4;
        URectangle uRectangle = new URectangle(d, d2);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.draw(uRectangle);
        if (dimension2D.getWidth() == 0.0) {
            d4 = d / 3.0;
            d3 = 12.0;
            n = 7;
        } else {
            d4 = dimension2D.getWidth() + 10.0;
            d3 = dimension2D.getHeight() + 3.0;
            n = 10;
        }
        UPath uPath = new UPath();
        uPath.moveTo(d4, 1.0);
        uPath.lineTo(d4, d3 - (double)n);
        uPath.lineTo(d4 - (double)n, d3);
        uPath.lineTo(0.0, d3);
        uGraphic.draw(uPath);
    }

    private void drawFolder(UGraphic uGraphic, double d, double d2, boolean bl) {
        double d3 = Math.max(30.0, d / 4.0);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(d3, 0.0);
        uPolygon.addPoint(d3 + 7.0, 10.0);
        uPolygon.addPoint(d, 10.0);
        uPolygon.addPoint(d, d2);
        uPolygon.addPoint(0.0, d2);
        uPolygon.addPoint(0.0, 0.0);
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        uGraphic.draw(uPolygon);
        uGraphic.apply(new UTranslate(0.0, 10.0)).draw(new ULine(d3 + 7.0, 0.0));
    }

    private void drawDatabase(UGraphic uGraphic, double d, double d2, boolean bl) {
        UPath uPath = new UPath();
        if (bl) {
            uPath.setDeltaShadow(3.0);
        }
        uPath.moveTo(0.0, 10.0);
        uPath.cubicTo(10.0, 0.0, d / 2.0 - 10.0, 0.0, d / 2.0, 0.0);
        uPath.cubicTo(d / 2.0 + 10.0, 0.0, d - 10.0, 0.0, d, 10.0);
        uPath.lineTo(d, d2 - 10.0);
        uPath.cubicTo(d - 10.0, d2, d / 2.0 - 10.0, d2, d / 2.0, d2);
        uPath.cubicTo(d / 2.0 + 10.0, d2, 10.0, d2, 0.0, d2 - 10.0);
        uPath.lineTo(0.0, 10.0);
        uGraphic.draw(uPath);
        UPath uPath2 = new UPath();
        uPath2.moveTo(0.0, 10.0);
        uPath2.cubicTo(10.0, 20.0, d / 2.0 - 10.0, 20.0, d / 2.0, 20.0);
        uPath2.cubicTo(d / 2.0 + 10.0, 20.0, d - 10.0, 20.0, d, 10.0);
        uGraphic.draw(uPath2);
    }

    private void drawNode(UGraphic uGraphic, double d, double d2, double d3, double d4, boolean bl) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 10.0);
        uPolygon.addPoint(10.0, 0.0);
        uPolygon.addPoint(d3, 0.0);
        uPolygon.addPoint(d3, d4 - 10.0);
        uPolygon.addPoint(d3 - 10.0, d4);
        uPolygon.addPoint(0.0, d4);
        uPolygon.addPoint(0.0, 10.0);
        if (bl) {
            uPolygon.setDeltaShadow(2.0);
        }
        uGraphic.apply(new UTranslate(d, d2)).draw(uPolygon);
        uGraphic.apply(new UTranslate(d + d3 - 10.0, d2 + 10.0)).draw(new ULine(9.0, -9.0));
        UPath uPath = new UPath();
        uPath.moveTo(0.0, 0.0);
        uPath.lineTo(d3 - 10.0, 0.0);
        uPath.lineTo(d3 - 10.0, d4 - 10.0);
        uGraphic.apply(new UTranslate(d, d2 + 10.0)).draw(uPath);
    }
}

