/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ExtremityArrow
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final ULine line;
    private final Point2D contact;

    public ExtremityArrow(Point2D point2D, double d, Point2D point2D2) {
        d = this.manageround(d);
        int n = this.buildPolygon();
        this.polygon.rotate(d + 1.5707963267948966);
        this.polygon = this.polygon.translate(point2D.getX(), point2D.getY());
        this.contact = new Point2D.Double(point2D.getX() - (double)n * Math.cos(d + 1.5707963267948966), point2D.getY() - (double)n * Math.sin(d + 1.5707963267948966));
        this.line = new ULine(point2D2.getX() - this.contact.getX(), point2D2.getY() - this.contact.getY());
    }

    public ExtremityArrow(Point2D point2D, double d) {
        this.line = null;
        d = this.manageround(d);
        this.buildPolygon();
        this.polygon.rotate(d);
        this.polygon = this.polygon.translate(point2D.getX(), point2D.getY());
        this.contact = point2D;
    }

    private int buildPolygon() {
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.addPoint(-9.0, -4.0);
        this.polygon.addPoint(-5.0, 0.0);
        this.polygon.addPoint(-9.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        return 5;
    }

    public void drawU(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UChangeBackColor(uGraphic.getParam().getColor()));
        uGraphic.draw(this.polygon);
        if (this.line != null && this.line.getLength() > 2.0) {
            uGraphic.apply(new UTranslate(this.contact.getX(), this.contact.getY())).draw(this.line);
        }
    }
}

