/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.USymbolFolder;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageDescription
extends AbstractEntityImage {
    private final ShapeType shapeType;
    private final Url url;
    private final TextBlock asSmall;
    private final TextBlock name;

    public EntityImageDescription(ILeaf iLeaf, ISkinParam iSkinParam, PortionShower portionShower) {
        super(iLeaf, iLeaf.getColors(iSkinParam).mute(iSkinParam));
        USymbol uSymbol;
        Stereotype stereotype = iLeaf.getStereotype();
        USymbol uSymbol2 = iLeaf.getUSymbol() == null ? (this.getSkinParam().useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1) : (uSymbol = iLeaf.getUSymbol());
        if (uSymbol == null) {
            throw new IllegalArgumentException();
        }
        this.shapeType = uSymbol == USymbol.FOLDER ? ShapeType.FOLDER : ShapeType.RECTANGLE;
        Display display = Display.getWithNewlines(iLeaf.getCode());
        TextBlock textBlock = iLeaf.getDisplay().equals(display) && uSymbol instanceof USymbolFolder || iLeaf.getDisplay().isWhite() ? TextBlockUtils.empty(0.0, 0.0) : new BodyEnhanced(iLeaf.getDisplay(), uSymbol.getFontParam(), this.getSkinParam(), HorizontalAlignment.CENTER, stereotype, uSymbol.manageHorizontalLine(), false, false);
        this.url = iLeaf.getUrl99();
        HtmlColor htmlColor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), uSymbol.getColorParamBack(), this.getStereo());
        }
        HtmlColor htmlColor2 = SkinParamUtils.getColor(this.getSkinParam(), uSymbol.getColorParamBorder(), this.getStereo());
        SymbolContext symbolContext = new SymbolContext(htmlColor, htmlColor2).withStroke(new UStroke(1.5)).withShadow(this.getSkinParam().shadowing2(uSymbol.getSkinParameter()));
        TextBlock textBlock2 = TextBlockUtils.empty(0.0, 0.0);
        if (stereotype != null && stereotype.getSprite() != null && this.getSkinParam().getSprite(stereotype.getSprite()) != null) {
            uSymbol = uSymbol.withStereoAlignment(HorizontalAlignment.RIGHT);
            textBlock2 = this.getSkinParam().getSprite(stereotype.getSprite()).asTextBlock(stereotype.getHtmlColor());
        } else if (stereotype != null && stereotype.getLabel(false) != null && portionShower.showPortion(EntityPortion.STEREOTYPE, iLeaf)) {
            textBlock2 = Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().useGuillemet())).create(new FontConfiguration(this.getSkinParam(), uSymbol.getFontParamStereotype(), stereotype), HorizontalAlignment.CENTER, this.getSkinParam());
        }
        this.name = new BodyEnhanced(display, uSymbol.getFontParam(), this.getSkinParam(), HorizontalAlignment.CENTER, stereotype, uSymbol.manageHorizontalLine(), false, false);
        this.asSmall = uSymbol.asSmall(this.name, textBlock, textBlock2, symbolContext);
    }

    public Dimension2D getNameDimension(StringBounder stringBounder) {
        return this.name.calculateDimension(stringBounder);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.asSmall.calculateDimension(stringBounder);
    }

    public final void drawU(UGraphic uGraphic) {
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        this.asSmall.drawU(uGraphic);
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public int getShield() {
        return 0;
    }
}

