/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.Sprite;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;

public class SpriteMonochrome
implements Sprite {
    private final int width;
    private final int height;
    private final int grayLevel;
    private final int[][] pixels;

    SpriteMonochrome(int n, int n2, int n3) {
        if (n3 != 2 && n3 != 4 && n3 != 8 && n3 != 16) {
            throw new IllegalArgumentException();
        }
        this.width = n;
        this.height = n2;
        this.grayLevel = n3;
        this.pixels = new int[n2][n];
    }

    void setPixel(int n, int n2, int n3) {
        if (n < 0 || n >= this.width) {
            return;
        }
        if (n2 < 0 || n2 >= this.height) {
            return;
        }
        if (n3 < 0 || n3 >= this.grayLevel) {
            throw new IllegalArgumentException("level=" + n3 + " grayLevel=" + this.grayLevel);
        }
        this.pixels[n2][n] = n3;
    }

    public int getHeight() {
        return this.height;
    }

    int getWidth() {
        return this.width;
    }

    public UImage toUImage(ColorMapper colorMapper, HtmlColor htmlColor, HtmlColor htmlColor2) {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        if (htmlColor == null) {
            htmlColor = HtmlColorUtils.WHITE;
        }
        if (htmlColor2 == null) {
            htmlColor2 = HtmlColorUtils.BLACK;
        }
        HtmlColorGradient htmlColorGradient = new HtmlColorGradient(htmlColor, htmlColor2, '\u0000');
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                double d = 1.0 * (double)this.pixels[j][i] / (double)(this.grayLevel - 1);
                Color color = htmlColorGradient.getColor(colorMapper, d);
                bufferedImage.setRGB(i, j, color.getRGB());
            }
        }
        return new UImage(bufferedImage);
    }

    public TextBlock asTextBlock(final HtmlColor htmlColor) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                uGraphic.draw(SpriteMonochrome.this.toUImage(uGraphic.getColorMapper(), uGraphic.getParam().getBackcolor(), htmlColor));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(SpriteMonochrome.this.getWidth(), SpriteMonochrome.this.getHeight());
            }
        };
    }
}

