/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.image.ContainingEllipse;
import net.sourceforge.plantuml.svek.image.Footprint;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockInEllipse
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock text;
    private final ContainingEllipse ellipse;

    public TextBlockInEllipse(TextBlock textBlock, StringBounder stringBounder) {
        this.text = textBlock;
        Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
        double d = dimension2D.getHeight() / dimension2D.getWidth();
        if (d < 0.2) {
            d = 0.2;
        } else if (d > 0.8) {
            d = 0.8;
        }
        Footprint footprint = new Footprint(stringBounder);
        this.ellipse = footprint.getEllipse(textBlock, d);
    }

    public UEllipse getUEllipse() {
        return this.ellipse.asUEllipse().bigger(6.0);
    }

    public void drawU(UGraphic uGraphic) {
        UEllipse uEllipse = this.getUEllipse();
        Point2D point2D = this.ellipse.getCenter();
        double d = uEllipse.getWidth() / 2.0 - point2D.getX();
        double d2 = uEllipse.getHeight() / 2.0 - point2D.getY();
        uGraphic.draw(uEllipse);
        this.text.drawU(uGraphic.apply(new UTranslate(d, d2 - 2.0)));
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getUEllipse().getDimension();
    }

    public void setDeltaShadow(double d) {
        this.ellipse.setDeltaShadow(d);
    }
}

