/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverEllipseEps
implements UDriver<EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverEllipseEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, EpsGraphics epsGraphics) {
        UEllipse uEllipse = (UEllipse)uShape;
        double d3 = uEllipse.getWidth();
        double d4 = uEllipse.getHeight();
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null) {
            if (!uClip.isInside(d, d2)) {
                return;
            }
            if (!uClip.isInside(d + d3, d2 + d4)) {
                return;
            }
        }
        if (uEllipse.getDeltaShadow() != 0.0) {
            epsGraphics.epsEllipseShadow(d + d3 / 2.0, d2 + d4 / 2.0, d3 / 2.0, d4 / 2.0, uEllipse.getDeltaShadow());
        }
        epsGraphics.setFillColor(colorMapper.getMappedColor(uParam.getBackcolor()));
        epsGraphics.setStrokeColor(colorMapper.getMappedColor(uParam.getColor()));
        epsGraphics.setStrokeWidth("" + uParam.getStroke().getThickness(), uParam.getStroke().getDashVisible(), uParam.getStroke().getDashSpace());
        if (uEllipse.getStart() == 0.0 && uEllipse.getExtend() == 0.0) {
            epsGraphics.epsEllipse(d + d3 / 2.0, d2 + d4 / 2.0, d3 / 2.0, d4 / 2.0);
        } else {
            epsGraphics.epsEllipse(d + d3 / 2.0, d2 + d4 / 2.0, d3 / 2.0, d4 / 2.0, uEllipse.getStart(), uEllipse.getExtend());
        }
    }
}

