/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.hand;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;

public class HandJiggle {
    private final Collection<Point2D> points = new ArrayList<Point2D>();
    private double startX;
    private double startY;
    private final double defaultVariation;

    public HandJiggle(double d, double d2, double d3) {
        this.startX = d;
        this.startY = d2;
        this.defaultVariation = d3;
        this.points.add(new Point2D.Double(d, d2));
    }

    public HandJiggle(Point2D point2D, double d) {
        this(point2D.getX(), point2D.getY(), d);
    }

    public void lineTo(Point2D point2D) {
        this.lineTo(point2D.getX(), point2D.getY());
    }

    public void arcTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.lineTo(HandJiggle.pointOnCircle(d3, d4, (d + d2) / 2.0, d5, d6));
        this.lineTo(HandJiggle.pointOnCircle(d3, d4, d2, d5, d6));
    }

    private static Point2D pointOnCircle(double d, double d2, double d3, double d4, double d5) {
        double d6 = d + Math.cos(d3) * d4;
        double d7 = d2 + Math.sin(d3) * d5;
        return new Point2D.Double(d6, d7);
    }

    public void lineTo(double d, double d2) {
        double d3;
        double d4 = Math.abs(d - this.startX);
        double d5 = Math.sqrt(d4 * d4 + (d3 = Math.abs(d2 - this.startY)) * d3);
        if (d5 < 0.001) {
            return;
        }
        int n = (int)Math.round(d5 / 10.0);
        double d6 = this.defaultVariation;
        if (n < 5) {
            n = 5;
            d6 /= 3.0;
        }
        double d7 = Math.signum(d - this.startX) * d4 / (double)n;
        double d8 = Math.signum(d2 - this.startY) * d3 / (double)n;
        double d9 = d4 / d5;
        double d10 = d3 / d5;
        for (int i = 0; i < n; ++i) {
            double d11 = d7 * (double)i + this.startX;
            double d12 = d8 * (double)i + this.startY;
            double d13 = (Math.random() - 0.5) * d6;
            this.points.add(new Point2D.Double(d11 - d13 * d10, d12 - d13 * d9));
        }
        this.points.add(new Point2D.Double(d, d2));
        this.startX = d;
        this.startY = d2;
    }

    public void curveTo(CubicCurve2D cubicCurve2D) {
        double d = cubicCurve2D.getFlatness();
        double d2 = cubicCurve2D.getP1().distance(cubicCurve2D.getP2());
        if (d > 0.1 && d2 > 20.0) {
            CubicCurve2D.Double double_ = new CubicCurve2D.Double();
            CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
            cubicCurve2D.subdivide(double_, double_2);
            this.curveTo(double_);
            this.curveTo(double_2);
            return;
        }
        this.lineTo(cubicCurve2D.getP2());
    }

    public UPolygon toUPolygon() {
        UPolygon uPolygon = new UPolygon();
        for (Point2D point2D : this.points) {
            uPolygon.addPoint(point2D.getX(), point2D.getY());
        }
        return uPolygon;
    }

    public UPath toUPath() {
        UPath uPath = null;
        for (Point2D point2D : this.points) {
            if (uPath == null) {
                uPath = new UPath();
                uPath.moveTo(point2D);
                continue;
            }
            uPath.lineTo(point2D);
        }
        if (uPath == null) {
            throw new IllegalStateException();
        }
        return uPath;
    }
}

