/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.mojo.cleanpom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.trajano.mojo.cleanpom.internal.EolNormalizingStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="clean", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class CleanMojo
extends AbstractMojo {
    private static final ResourceBundle R = ResourceBundle.getBundle("META-INF/Messages");
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${basedir}/pom.xml", property="cleanpom.pomFile", required=false)
    private File pomFile;
    @Parameter(defaultValue="/META-INF/pom-clean.xslt", required=false, property="cleanpom.xsltFileList")
    private String xsltFileList;
    @Parameter(required=false)
    private String[] xsltFiles;

    private TransformerHandler buildHandlerChain(SAXTransformerFactory tf, OutputStream outputStream) throws IOException, TransformerException {
        TransformerHandler handler = null;
        TransformerHandler lastHandler = null;
        for (String xsltFile : this.xsltFiles) {
            InputStream xsltStream = ((Object)((Object)this)).getClass().getResourceAsStream(xsltFile.charAt(0) == '/' ? xsltFile : "/META-INF/" + xsltFile);
            TransformerHandler currentHandler = tf.newTransformerHandler(new StreamSource(xsltStream));
            xsltStream.close();
            if (lastHandler != null) {
                lastHandler.setResult(new SAXResult(currentHandler));
                lastHandler = currentHandler;
                continue;
            }
            lastHandler = currentHandler;
            handler = currentHandler;
        }
        if (lastHandler != null) {
            lastHandler.setResult(new StreamResult(outputStream));
            return handler;
        }
        throw new TransformerException("Unable to build handler chain");
    }

    private File buildTempFile() throws MojoExecutionException {
        File tempFile;
        try {
            tempFile = File.createTempFile("pom", "xml");
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        try {
            if (this.pomFile == null) {
                this.pomFile = new File("pom.xml");
            }
            FileUtils.copyFile((File)this.pomFile, (File)tempFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format(R.getString("copyfail"), this.pomFile, tempFile), (Exception)e);
        }
        return tempFile;
    }

    public void execute() throws MojoExecutionException {
        File tempFile = this.buildTempFile();
        this.transform(tempFile, this.pomFile);
    }

    public void setXsltFiles(String[] xsltFiles) {
        this.xsltFiles = xsltFiles;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void transform(File sourceFile, File targetFile) throws MojoExecutionException {
        OutputStream outputStream = null;
        try {
            SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
            if (this.xsltFiles == null) {
                this.xsltFiles = this.xsltFileList != null ? StringUtils.split((String)this.xsltFileList, (String)",") : new String[]{"/META-INF/pom-clean.xslt"};
            }
            outputStream = this.buildContext.newFileOutputStream(targetFile);
            TransformerHandler handler = this.buildHandlerChain(tf, new EolNormalizingStream(outputStream));
            Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(sourceFile), new SAXResult(handler));
            this.getLog().debug((CharSequence)String.format(R.getString("donecleaning"), targetFile));
            FileUtils.forceDelete((File)sourceFile);
        }
        catch (TransformerException e) {
            try {
                throw new MojoExecutionException(String.format(R.getString("transformfail"), sourceFile), (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException(String.format(R.getString("transformfailio"), sourceFile), (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(outputStream);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)outputStream);
    }
}

