/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.mojo.cleanpom;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.trajano.mojo.cleanpom.internal.DtdResolver;
import net.trajano.mojo.cleanpom.internal.EolNormalizingStream;
import net.trajano.mojo.cleanpom.internal.Messages;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@Mojo(name="clean-xml", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class CleanXmlMojo
extends AbstractMojo {
    private static final ResourceBundle R = ResourceBundle.getBundle("META-INF/Messages");
    @Component
    private BuildContext buildContext;
    @Parameter(required=false)
    private FileSet[] xmlFileSets;

    public void execute() throws MojoExecutionException {
        File tempFile;
        if (this.xmlFileSets == null) {
            this.xmlFileSets = new FileSet[2];
            this.xmlFileSets[0] = new FileSet();
            this.xmlFileSets[0].setDirectory("src/main");
            this.xmlFileSets[0].addInclude("**/*.xml");
            this.xmlFileSets[0].addInclude("**/*.xsd");
            this.xmlFileSets[0].addInclude("**/*.xslt");
            this.xmlFileSets[1] = new FileSet();
            this.xmlFileSets[1].setDirectory("src/site");
            this.xmlFileSets[1].addInclude("**/*.xml");
        }
        try {
            tempFile = File.createTempFile("temp", "xml");
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        for (FileSet xmlFiles : this.xmlFileSets) {
            File dir = new File(xmlFiles.getDirectory());
            if (!dir.exists()) continue;
            Scanner scanner = this.buildContext.newScanner(dir, false);
            scanner.setIncludes(xmlFiles.getIncludes().toArray(new String[0]));
            scanner.scan();
            for (String includedFile : scanner.getIncludedFiles()) {
                File file = new File(scanner.getBasedir(), includedFile);
                try {
                    FileUtils.copyFile((File)file, (File)tempFile);
                    this.transform(tempFile, file);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(String.format(R.getString("copyfail"), file, tempFile), (Exception)e);
                }
            }
        }
        if (tempFile.exists()) {
            try {
                FileUtils.forceDelete((File)tempFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    public void setXmlFileSets(FileSet[] xmlFileSets) {
        this.xmlFileSets = xmlFileSets;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void transform(File sourceFile, File targetFile) throws MojoExecutionException {
        FileInputStream source = null;
        OutputStream outputStream = null;
        try {
            Transformer transformer;
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            DtdResolver resolver = new DtdResolver();
            xmlReader.setEntityResolver(resolver);
            xmlReader.setContentHandler(resolver);
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", resolver);
            source = new FileInputStream(sourceFile);
            xmlReader.parse(new InputSource(source));
            source.close();
            source = new FileInputStream(sourceFile);
            SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
            outputStream = this.buildContext.newFileOutputStream(targetFile);
            if (resolver.isDtdPresent()) {
                transformer = tf.newTransformer(new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/clean-with-dtd.xslt")));
                transformer.setOutputProperty("{http://xml.apache.org/xalan}line-separator", "\n");
                transformer.setParameter("dtdname", resolver.getName());
                if (resolver.getPublicId() != null) {
                    transformer.setParameter("doctype-public", resolver.getPublicId());
                    transformer.setParameter("doctype-system", resolver.getSystemId());
                }
            } else {
                transformer = tf.newTransformer(new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/clean.xslt")));
            }
            transformer.transform(new SAXSource(xmlReader, new InputSource(source)), new StreamResult(new EolNormalizingStream(outputStream)));
            this.getLog().debug((CharSequence)String.format(R.getString("donecleaning"), targetFile));
            IOUtil.close((InputStream)source);
            FileUtils.forceDelete((File)sourceFile);
        }
        catch (SAXException e) {
            try {
                throw new MojoExecutionException(String.format(Messages.TRANSFORM_FAIL, targetFile), (Exception)e);
                catch (TransformerException e2) {
                    throw new MojoExecutionException(String.format(Messages.TRANSFORM_FAIL, targetFile), (Exception)e2);
                }
                catch (IOException e3) {
                    throw new MojoExecutionException(String.format(Messages.TRANSFORM_FAIL_IO, targetFile), (Exception)e3);
                }
                catch (ParserConfigurationException e4) {
                    throw new MojoExecutionException(String.format(Messages.TRANSFORM_FAIL, targetFile), (Exception)e4);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(source);
                IOUtil.close(outputStream);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)source);
        IOUtil.close((OutputStream)outputStream);
    }
}

