/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.wagon.git.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.trajano.wagon.git.internal.GitUri;
import net.trajano.wagon.git.internal.PassphraseCredentialsProvider;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public abstract class AbstractGitWagon
extends StreamWagon {
    private static final Logger LOG = Logger.getLogger("net.trajano.wagon.git", "META-INF/Messages");
    private static final String MESSAGES = "META-INF/Messages";
    private static final ResourceBundle R = ResourceBundle.getBundle("META-INF/Messages");
    private CredentialsProvider credentialsProvider;
    private final ConcurrentMap<String, Git> gitCache = new ConcurrentHashMap<String, Git>();
    private GitUri gitUri;

    protected abstract GitUri buildGitUri(URI var1) throws IOException, URISyntaxException;

    public void closeConnection() throws ConnectionException {
        try {
            for (Map.Entry gitEntry : this.gitCache.entrySet()) {
                Git git = (Git)gitEntry.getValue();
                git.add().addFilepattern(".").call();
                git.commit().setMessage(R.getString("commitmessage")).call();
                ((PushCommand)git.push().setRemote((String)gitEntry.getKey()).setCredentialsProvider(this.credentialsProvider)).call();
                git.close();
                FileUtils.deleteDirectory((File)git.getRepository().getDirectory());
            }
        }
        catch (GitAPIException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            File file = this.getFileForResource(inputData.getResource().getName());
            if (!file.exists()) {
                throw new ResourceDoesNotExistException(String.format(R.getString("filenotfound"), file));
            }
            if (!file.canRead()) {
                throw new AuthorizationException(String.format(R.getString("cannotreadfile"), file));
            }
            inputData.setInputStream((InputStream)new FileInputStream(file));
            inputData.getResource().setContentLength(file.length());
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        try {
            File file = this.getFileForResource(outputData.getResource().getName());
            if (!file.getParentFile().mkdirs() && !file.getParentFile().exists()) {
                throw new TransferFailedException(String.format(R.getString("unabletocreatedirs"), file.getParentFile()));
            }
            outputData.setOutputStream((OutputStream)new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract File getFileForResource(String var1) throws GitAPIException, IOException, URISyntaxException;

    public List<String> getFileList(String directory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File dir;
        try {
            dir = this.getFileForResource(directory);
        }
        catch (GitAPIException e) {
            throw new AuthorizationException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ResourceDoesNotExistException(e.getMessage(), (Throwable)e);
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new ResourceDoesNotExistException(String.format(R.getString("dirnotfound"), dir));
        }
        LinkedList<String> list = new LinkedList<String>();
        for (File file : files) {
            String name = file.getName();
            if (file.isDirectory() && !name.endsWith("/")) {
                name = name + "/";
            }
            list.add(name);
        }
        return list;
    }

    protected Git getGit(String gitRepositoryUri) throws GitAPIException, IOException, URISyntaxException, ResourceDoesNotExistException {
        Git cachedGit = (Git)this.gitCache.get(gitRepositoryUri);
        if (cachedGit != null) {
            return cachedGit;
        }
        File gitDir = File.createTempFile(gitRepositoryUri.replaceAll("[^A-Za-z]", "_"), "wagon-git");
        gitDir.delete();
        gitDir.mkdir();
        this.credentialsProvider = this.getAuthenticationInfo().getUserName() != null ? new UsernamePasswordCredentialsProvider(this.getAuthenticationInfo().getUserName(), this.getAuthenticationInfo().getPassword() == null ? "" : this.getAuthenticationInfo().getPassword()) : new PassphraseCredentialsProvider(this.getAuthenticationInfo().getPassword());
        try {
            Git git = ((CloneCommand)Git.cloneRepository().setURI(gitRepositoryUri).setCredentialsProvider(this.credentialsProvider)).setBranch(this.gitUri.getBranchName()).setDirectory(gitDir).call();
            if (!this.gitUri.getBranchName().equals(git.getRepository().getBranch())) {
                LOG.log(Level.INFO, "missingbranch", this.gitUri.getBranchName());
                RefUpdate refUpdate = git.getRepository().getRefDatabase().newUpdate("HEAD", true);
                refUpdate.setForceUpdate(true);
                refUpdate.link("refs/heads/" + this.gitUri.getBranchName());
            }
            this.gitCache.put(gitRepositoryUri, git);
            return git;
        }
        catch (InvalidRemoteException e) {
            throw new ResourceDoesNotExistException(e.getMessage(), (Throwable)e);
        }
        catch (NoRemoteRepositoryException e) {
            throw new ResourceDoesNotExistException(e.getMessage(), (Throwable)e);
        }
    }

    protected GitUri getGitUri() {
        return this.gitUri;
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        try {
            URI uri = new URI(new URI(this.getRepository().getUrl().replace("##", "#")).getSchemeSpecificPart()).normalize();
            this.gitUri = this.buildGitUri(uri);
        }
        catch (URISyntaxException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            if (!sourceDirectory.isDirectory()) {
                throw new ResourceDoesNotExistException(String.format(R.getString("dirnotfound"), sourceDirectory));
            }
            File fileForResource = this.getFileForResource(destinationDirectory);
            if (fileForResource == null) {
                throw new ResourceDoesNotExistException(String.format(R.getString("dirnotfound"), destinationDirectory));
            }
            FileUtils.copyDirectoryStructure((File)sourceDirectory, (File)fileForResource);
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException {
        File file;
        try {
            file = this.getFileForResource(resourceName);
        }
        catch (GitAPIException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        if (resourceName.endsWith("/")) {
            return file.isDirectory();
        }
        return file.exists();
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }
}

