/*
 * Decompiled with CFR 0.152.
 */
package eu.peppol.jdbc;

import eu.peppol.jdbc.OxalisDataSourceFactory;
import eu.peppol.util.GlobalConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OxalisDataSourceFactoryDbcpImpl
implements OxalisDataSourceFactory {
    public static final Logger log = LoggerFactory.getLogger(OxalisDataSourceFactoryDbcpImpl.class);

    public DataSource getDataSource() {
        return DataSourceHolder.INSTANCE;
    }

    public static DataSource configureAndCreateDataSource() {
        log.debug("Configuring DataSource wrapped in a Database Connection Pool, using custom loader");
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getInstance();
        String jdbcDriverClassPath = globalConfiguration.getJdbcDriverClassPath();
        log.debug("Loading JDBC Driver with custom class path: " + jdbcDriverClassPath);
        URLClassLoader urlClassLoader = OxalisDataSourceFactoryDbcpImpl.getOxalisClassLoaderForJdbc(jdbcDriverClassPath);
        String className = globalConfiguration.getJdbcDriverClassName();
        String connectURI = globalConfiguration.getJdbcConnectionURI();
        String userName = globalConfiguration.getJdbcUsername();
        String password = globalConfiguration.getJdbcPassword();
        log.debug("className=" + className);
        log.debug("connectURI=" + connectURI);
        log.debug("userName=" + userName);
        log.debug("password=" + password);
        Driver driver = OxalisDataSourceFactoryDbcpImpl.getJdbcDriver(jdbcDriverClassPath, urlClassLoader, className);
        Properties properties = new Properties();
        properties.put("user", userName);
        properties.put("password", password);
        DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driver, connectURI, properties);
        GenericObjectPool genericObjectPool = new GenericObjectPool(null);
        genericObjectPool.setMaxActive(100);
        genericObjectPool.setMaxIdle(30);
        genericObjectPool.setMaxWait(10000L);
        genericObjectPool.setTestOnBorrow(true);
        genericObjectPool.setTestWhileIdle(true);
        genericObjectPool.setTimeBetweenEvictionRunsMillis(3600000L);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)driverConnectionFactory, (ObjectPool)genericObjectPool, null, null, false, true);
        String validationQuery = GlobalConfiguration.getInstance().getValidationQuery();
        poolableConnectionFactory.setValidationQuery(validationQuery);
        PoolingDataSource poolingDataSource = new PoolingDataSource((ObjectPool)genericObjectPool);
        return poolingDataSource;
    }

    private static Driver getJdbcDriver(String jdbcDriverClassPath, URLClassLoader urlClassLoader, String className) {
        Class<?> aClass = null;
        try {
            aClass = Class.forName(className, true, urlClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to locate class " + className + " in " + jdbcDriverClassPath);
        }
        Driver driver = null;
        try {
            driver = (Driver)aClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to instantiate driver from class " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to access driver class " + className + "; " + e, e);
        }
        return driver;
    }

    private static URLClassLoader getOxalisClassLoaderForJdbc(String jdbcDriverClassPath) {
        URLClassLoader urlClassLoader = null;
        try {
            urlClassLoader = new URLClassLoader(new URL[]{new URL(jdbcDriverClassPath)}, Thread.currentThread().getContextClassLoader());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid jdbc driver class path: '" + jdbcDriverClassPath + "', check property oxalis.jdbc.class.path");
        }
        return urlClassLoader;
    }

    private static class DataSourceHolder {
        private static final DataSource INSTANCE = OxalisDataSourceFactoryDbcpImpl.configureAndCreateDataSource();

        private DataSourceHolder() {
        }
    }
}

