/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.associations.AbstractAssociator;
import weka.associations.AprioriItemSet;
import weka.associations.AssociationRule;
import weka.associations.AssociationRules;
import weka.associations.AssociationRulesProducer;
import weka.associations.CARuleMiner;
import weka.associations.DefaultAssociationRule;
import weka.associations.Item;
import weka.associations.ItemSet;
import weka.associations.LabeledItemSet;
import weka.associations.NominalItem;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class Apriori
extends AbstractAssociator
implements OptionHandler,
AssociationRulesProducer,
CARuleMiner,
TechnicalInformationHandler {
    static final long serialVersionUID = 3277498842319212687L;
    protected double m_minSupport;
    protected double m_upperBoundMinSupport;
    protected double m_lowerBoundMinSupport;
    protected static final int CONFIDENCE = 0;
    protected static final int LIFT = 1;
    protected static final int LEVERAGE = 2;
    protected static final int CONVICTION = 3;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(0, "Confidence"), new Tag(1, "Lift"), new Tag(2, "Leverage"), new Tag(3, "Conviction")};
    protected int m_metricType = 0;
    protected double m_minMetric;
    protected int m_numRules;
    protected double m_delta;
    protected double m_significanceLevel;
    protected int m_cycles;
    protected FastVector m_Ls;
    protected FastVector m_hashtables;
    protected FastVector[] m_allTheRules;
    protected Instances m_instances;
    protected boolean m_outputItemSets;
    protected boolean m_removeMissingCols;
    protected boolean m_verbose;
    protected Instances m_onlyClass;
    protected int m_classIndex;
    protected boolean m_car;
    protected boolean m_treatZeroAsMissing = false;
    protected String m_toStringDelimiters = null;

    public String globalInfo() {
        return "Class implementing an Apriori-type algorithm. Iteratively reduces the minimum support until it finds the required number of rules with the given minimum confidence.\nThe algorithm has an option to mine class association rules. It is adapted as explained in the second reference.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "R. Agrawal and R. Srikant");
        result.setValue(TechnicalInformation.Field.TITLE, "Fast Algorithms for Mining Association Rules in Large Databases");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "20th International Conference on Very Large Data Bases");
        result.setValue(TechnicalInformation.Field.YEAR, "1994");
        result.setValue(TechnicalInformation.Field.PAGES, "478-499");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann, Los Altos, CA");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Bing Liu and Wynne Hsu and Yiming Ma");
        additional.setValue(TechnicalInformation.Field.TITLE, "Integrating Classification and Association Rule Mining");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "Fourth International Conference on Knowledge Discovery and Data Mining");
        additional.setValue(TechnicalInformation.Field.YEAR, "1998");
        additional.setValue(TechnicalInformation.Field.PAGES, "80-86");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "AAAI Press");
        return result;
    }

    public Apriori() {
        this.resetOptions();
    }

    public void resetOptions() {
        this.m_removeMissingCols = false;
        this.m_verbose = false;
        this.m_delta = 0.05;
        this.m_minMetric = 0.9;
        this.m_numRules = 10;
        this.m_lowerBoundMinSupport = 0.1;
        this.m_upperBoundMinSupport = 1.0;
        this.m_significanceLevel = -1.0;
        this.m_outputItemSets = false;
        this.m_car = false;
        this.m_classIndex = -1;
        this.m_treatZeroAsMissing = false;
        this.m_metricType = 0;
    }

    protected Instances removeMissingColumns(Instances instances) throws Exception {
        int numInstances = instances.numInstances();
        StringBuffer deleteString = new StringBuffer();
        int removeCount = 0;
        boolean first = true;
        int maxCount = 0;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            int[] counts;
            AttributeStats as = instances.attributeStats(i);
            if (this.m_upperBoundMinSupport == 1.0 && maxCount != numInstances && (counts = as.nominalCounts)[Utils.maxIndex(counts)] > maxCount) {
                maxCount = counts[Utils.maxIndex(counts)];
            }
            if (as.missingCount != numInstances) continue;
            if (first) {
                deleteString.append(i + 1);
                first = false;
            } else {
                deleteString.append("," + (i + 1));
            }
            ++removeCount;
        }
        if (this.m_verbose) {
            System.err.println("Removed : " + removeCount + " columns with all missing " + "values.");
        }
        if (this.m_upperBoundMinSupport == 1.0 && maxCount != numInstances) {
            this.m_upperBoundMinSupport = (double)maxCount / (double)numInstances;
            if (this.m_verbose) {
                System.err.println("Setting upper bound min support to : " + this.m_upperBoundMinSupport);
            }
        }
        if (deleteString.toString().length() > 0) {
            Remove af = new Remove();
            af.setAttributeIndices(deleteString.toString());
            af.setInvertSelection(false);
            af.setInputFormat(instances);
            Instances newInst = Filter.useFilter(instances, af);
            return newInst;
        }
        return instances;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildAssociations(Instances instances) throws Exception {
        double lowerBoundMinSupportToUse;
        double necSupport = 0.0;
        instances = new Instances(instances);
        if (this.m_removeMissingCols) {
            instances = this.removeMissingColumns(instances);
        }
        if (this.m_car && this.m_metricType != 0) {
            throw new Exception("For CAR-Mining metric type has to be confidence!");
        }
        if (this.m_car) {
            if (this.m_classIndex == -1) {
                instances.setClassIndex(instances.numAttributes() - 1);
            } else if (this.m_classIndex <= instances.numAttributes() && this.m_classIndex > 0) {
                instances.setClassIndex(this.m_classIndex - 1);
            } else {
                throw new Exception("Invalid class index.");
            }
        }
        this.getCapabilities().testWithFail(instances);
        this.m_cycles = 0;
        double d = lowerBoundMinSupportToUse = this.m_lowerBoundMinSupport * (double)instances.numInstances() < 1.0 ? 1.0 / (double)instances.numInstances() : this.m_lowerBoundMinSupport;
        if (this.m_car) {
            this.m_instances = LabeledItemSet.divide(instances, false);
            this.m_onlyClass = LabeledItemSet.divide(instances, true);
        } else {
            this.m_instances = instances;
        }
        if (this.m_car && this.m_numRules == Integer.MAX_VALUE) {
            this.m_minSupport = lowerBoundMinSupportToUse;
        } else {
            this.m_minSupport = 1.0 - this.m_delta;
            this.m_minSupport = this.m_minSupport < lowerBoundMinSupportToUse ? lowerBoundMinSupportToUse : this.m_minSupport;
        }
        do {
            int i;
            int i2;
            this.m_Ls = new FastVector();
            this.m_hashtables = new FastVector();
            this.m_allTheRules = new FastVector[6];
            this.m_allTheRules[0] = new FastVector();
            this.m_allTheRules[1] = new FastVector();
            this.m_allTheRules[2] = new FastVector();
            this.m_allTheRules[3] = new FastVector();
            this.m_allTheRules[4] = new FastVector();
            this.m_allTheRules[5] = new FastVector();
            FastVector[] sortedRuleSet = new FastVector[]{new FastVector(), new FastVector(), new FastVector(), new FastVector(), new FastVector(), new FastVector()};
            if (!this.m_car) {
                this.findLargeItemSets();
                if (this.m_significanceLevel != -1.0 || this.m_metricType != 0) {
                    this.findRulesBruteForce();
                } else {
                    this.findRulesQuickly();
                }
            } else {
                this.findLargeCarItemSets();
                this.findCarRulesQuickly();
            }
            if (this.m_upperBoundMinSupport < 1.0) {
                this.pruneRulesForUpperBoundSupport();
            }
            int j = this.m_allTheRules[2].size() - 1;
            double[] supports = new double[this.m_allTheRules[2].size()];
            for (i2 = 0; i2 < j + 1; ++i2) {
                supports[j - i2] = (double)((ItemSet)this.m_allTheRules[1].elementAt(j - i2)).support() * -1.0;
            }
            int[] indices = Utils.stableSort(supports);
            for (i2 = 0; i2 < j + 1; ++i2) {
                sortedRuleSet[0].addElement(this.m_allTheRules[0].elementAt(indices[j - i2]));
                sortedRuleSet[1].addElement(this.m_allTheRules[1].elementAt(indices[j - i2]));
                sortedRuleSet[2].addElement(this.m_allTheRules[2].elementAt(indices[j - i2]));
                if (this.m_car) continue;
                sortedRuleSet[3].addElement(this.m_allTheRules[3].elementAt(indices[j - i2]));
                sortedRuleSet[4].addElement(this.m_allTheRules[4].elementAt(indices[j - i2]));
                sortedRuleSet[5].addElement(this.m_allTheRules[5].elementAt(indices[j - i2]));
            }
            this.m_allTheRules[0].removeAllElements();
            this.m_allTheRules[1].removeAllElements();
            this.m_allTheRules[2].removeAllElements();
            this.m_allTheRules[3].removeAllElements();
            this.m_allTheRules[4].removeAllElements();
            this.m_allTheRules[5].removeAllElements();
            double[] confidences = new double[sortedRuleSet[2].size()];
            int sortType = 2 + this.m_metricType;
            for (i = 0; i < sortedRuleSet[2].size(); ++i) {
                confidences[i] = (Double)sortedRuleSet[sortType].elementAt(i);
            }
            indices = Utils.stableSort(confidences);
            for (i = sortedRuleSet[0].size() - 1; i >= sortedRuleSet[0].size() - this.m_numRules && i >= 0; --i) {
                this.m_allTheRules[0].addElement(sortedRuleSet[0].elementAt(indices[i]));
                this.m_allTheRules[1].addElement(sortedRuleSet[1].elementAt(indices[i]));
                this.m_allTheRules[2].addElement(sortedRuleSet[2].elementAt(indices[i]));
                if (this.m_car) continue;
                this.m_allTheRules[3].addElement(sortedRuleSet[3].elementAt(indices[i]));
                this.m_allTheRules[4].addElement(sortedRuleSet[4].elementAt(indices[i]));
                this.m_allTheRules[5].addElement(sortedRuleSet[5].elementAt(indices[i]));
            }
            if (this.m_verbose && this.m_Ls.size() > 1) {
                System.out.println(this.toString());
            }
            this.m_minSupport = this.m_minSupport == lowerBoundMinSupportToUse || this.m_minSupport - this.m_delta > lowerBoundMinSupportToUse ? (this.m_minSupport -= this.m_delta) : lowerBoundMinSupportToUse;
            necSupport = Math.rint(this.m_minSupport * (double)this.m_instances.numInstances());
            ++this.m_cycles;
        } while (this.m_allTheRules[0].size() < this.m_numRules && Utils.grOrEq(this.m_minSupport, lowerBoundMinSupportToUse) && necSupport >= 1.0);
        this.m_minSupport += this.m_delta;
    }

    private void pruneRulesForUpperBoundSupport() {
        int i;
        int necMaxSupport = (int)(this.m_upperBoundMinSupport * (double)this.m_instances.numInstances() + 0.5);
        FastVector[] prunedRules = new FastVector[6];
        for (i = 0; i < 6; ++i) {
            prunedRules[i] = new FastVector();
        }
        for (i = 0; i < this.m_allTheRules[0].size(); ++i) {
            if (((ItemSet)this.m_allTheRules[1].elementAt(i)).support() > necMaxSupport) continue;
            prunedRules[0].addElement(this.m_allTheRules[0].elementAt(i));
            prunedRules[1].addElement(this.m_allTheRules[1].elementAt(i));
            prunedRules[2].addElement(this.m_allTheRules[2].elementAt(i));
            if (this.m_car) continue;
            prunedRules[3].addElement(this.m_allTheRules[3].elementAt(i));
            prunedRules[4].addElement(this.m_allTheRules[4].elementAt(i));
            prunedRules[5].addElement(this.m_allTheRules[5].elementAt(i));
        }
        this.m_allTheRules[0] = prunedRules[0];
        this.m_allTheRules[1] = prunedRules[1];
        this.m_allTheRules[2] = prunedRules[2];
        this.m_allTheRules[3] = prunedRules[3];
        this.m_allTheRules[4] = prunedRules[4];
        this.m_allTheRules[5] = prunedRules[5];
    }

    @Override
    public FastVector[] mineCARs(Instances data) throws Exception {
        this.m_car = true;
        this.buildAssociations(data);
        return this.m_allTheRules;
    }

    @Override
    public Instances getInstancesNoClass() {
        return this.m_instances;
    }

    @Override
    public Instances getInstancesOnlyClass() {
        return this.m_onlyClass;
    }

    @Override
    public Enumeration listOptions() {
        String string1 = "\tThe required number of rules. (default = " + this.m_numRules + ")";
        String string2 = "\tThe minimum confidence of a rule. (default = " + this.m_minMetric + ")";
        String string3 = "\tThe delta by which the minimum support is decreased in\n";
        String string4 = "\teach iteration. (default = " + this.m_delta + ")";
        String string5 = "\tThe lower bound for the minimum support. (default = " + this.m_lowerBoundMinSupport + ")";
        String string6 = "\tIf used, rules are tested for significance at\n";
        String string7 = "\tthe given level. Slower. (default = no significance testing)";
        String string8 = "\tIf set the itemsets found are also output. (default = no)";
        String string9 = "\tIf set class association rules are mined. (default = no)";
        String string10 = "\tThe class index. (default = last)";
        String stringType = "\tThe metric type by which to rank rules. (default = confidence)";
        String stringZeroAsMissing = "\tTreat zero (i.e. first value of nominal attributes) as missing";
        String stringToStringDelimiters = "\tIf used, two characters to use as rule delimiters\n\tin the result of toString: the first to delimit fields,\n\tthe second to delimit items within fields.\n\t(default = traditional toString result)";
        FastVector<Option> newVector = new FastVector<Option>(14);
        newVector.addElement(new Option(string1, "N", 1, "-N <required number of rules output>"));
        newVector.addElement(new Option(stringType, "T", 1, "-T <0=confidence | 1=lift | 2=leverage | 3=Conviction>"));
        newVector.addElement(new Option(string2, "C", 1, "-C <minimum metric score of a rule>"));
        newVector.addElement(new Option(string3 + string4, "D", 1, "-D <delta for minimum support>"));
        newVector.addElement(new Option("\tUpper bound for minimum support. (default = 1.0)", "U", 1, "-U <upper bound for minimum support>"));
        newVector.addElement(new Option(string5, "M", 1, "-M <lower bound for minimum support>"));
        newVector.addElement(new Option(string6 + string7, "S", 1, "-S <significance level>"));
        newVector.addElement(new Option(string8, "I", 0, "-I"));
        newVector.addElement(new Option("\tRemove columns that contain all missing values (default = no)", "R", 0, "-R"));
        newVector.addElement(new Option("\tReport progress iteratively. (default = no)", "V", 0, "-V"));
        newVector.addElement(new Option(string9, "A", 0, "-A"));
        newVector.addElement(new Option(stringZeroAsMissing, "Z", 0, "-Z"));
        newVector.addElement(new Option(stringToStringDelimiters, "B", 1, "-B <toString delimiters>"));
        newVector.addElement(new Option(string10, "c", 1, "-c <the class index>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String numRulesString = Utils.getOption('N', options);
        String minConfidenceString = Utils.getOption('C', options);
        String deltaString = Utils.getOption('D', options);
        String maxSupportString = Utils.getOption('U', options);
        String minSupportString = Utils.getOption('M', options);
        String significanceLevelString = Utils.getOption('S', options);
        String classIndexString = Utils.getOption('c', options);
        String toStringDelimitersString = Utils.getOption('B', options);
        String metricTypeString = Utils.getOption('T', options);
        if (metricTypeString.length() != 0) {
            this.setMetricType(new SelectedTag(Integer.parseInt(metricTypeString), TAGS_SELECTION));
        }
        if (numRulesString.length() != 0) {
            this.m_numRules = Integer.parseInt(numRulesString);
        }
        if (classIndexString.length() != 0) {
            this.m_classIndex = classIndexString.equalsIgnoreCase("last") ? -1 : (classIndexString.equalsIgnoreCase("first") ? 0 : Integer.parseInt(classIndexString));
        }
        if (minConfidenceString.length() != 0) {
            this.m_minMetric = new Double(minConfidenceString);
        }
        if (deltaString.length() != 0) {
            this.m_delta = new Double(deltaString);
        }
        if (maxSupportString.length() != 0) {
            this.setUpperBoundMinSupport(new Double(maxSupportString));
        }
        if (minSupportString.length() != 0) {
            this.m_lowerBoundMinSupport = new Double(minSupportString);
        }
        if (significanceLevelString.length() != 0) {
            this.m_significanceLevel = new Double(significanceLevelString);
        }
        this.m_outputItemSets = Utils.getFlag('I', options);
        this.m_car = Utils.getFlag('A', options);
        this.m_verbose = Utils.getFlag('V', options);
        this.m_treatZeroAsMissing = Utils.getFlag('Z', options);
        this.setRemoveAllMissingCols(Utils.getFlag('R', options));
        if (toStringDelimitersString.length() == 2) {
            this.m_toStringDelimiters = toStringDelimitersString;
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[23];
        int current = 0;
        if (this.m_outputItemSets) {
            options[current++] = "-I";
        }
        if (this.getRemoveAllMissingCols()) {
            options[current++] = "-R";
        }
        options[current++] = "-N";
        options[current++] = "" + this.m_numRules;
        options[current++] = "-T";
        options[current++] = "" + this.m_metricType;
        options[current++] = "-C";
        options[current++] = "" + this.m_minMetric;
        options[current++] = "-D";
        options[current++] = "" + this.m_delta;
        options[current++] = "-U";
        options[current++] = "" + this.m_upperBoundMinSupport;
        options[current++] = "-M";
        options[current++] = "" + this.m_lowerBoundMinSupport;
        options[current++] = "-S";
        options[current++] = "" + this.m_significanceLevel;
        if (this.m_car) {
            options[current++] = "-A";
        }
        if (this.m_verbose) {
            options[current++] = "-V";
        }
        if (this.m_treatZeroAsMissing) {
            options[current++] = "-Z";
        }
        options[current++] = "-c";
        options[current++] = "" + this.m_classIndex;
        if (this.m_toStringDelimiters != null) {
            options[current++] = "-B";
            options[current++] = this.m_toStringDelimiters;
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_Ls.size() <= 1) {
            return "\nNo large itemsets and rules found!\n";
        }
        text.append("\nApriori\n=======\n\n");
        text.append("Minimum support: " + Utils.doubleToString(this.m_minSupport, 2) + " (" + (int)(this.m_minSupport * (double)this.m_instances.numInstances() + 0.5) + " instances)" + '\n');
        text.append("Minimum metric <");
        switch (this.m_metricType) {
            case 0: {
                text.append("confidence>: ");
                break;
            }
            case 1: {
                text.append("lift>: ");
                break;
            }
            case 2: {
                text.append("leverage>: ");
                break;
            }
            case 3: {
                text.append("conviction>: ");
            }
        }
        text.append(Utils.doubleToString(this.m_minMetric, 2) + '\n');
        if (this.m_significanceLevel != -1.0) {
            text.append("Significance level: " + Utils.doubleToString(this.m_significanceLevel, 2) + '\n');
        }
        text.append("Number of cycles performed: " + this.m_cycles + '\n');
        text.append("\nGenerated sets of large itemsets:\n");
        if (!this.m_car) {
            int i;
            for (i = 0; i < this.m_Ls.size(); ++i) {
                text.append("\nSize of set of large itemsets L(" + (i + 1) + "): " + ((FastVector)this.m_Ls.elementAt(i)).size() + '\n');
                if (!this.m_outputItemSets) continue;
                text.append("\nLarge Itemsets L(" + (i + 1) + "):\n");
                for (int j = 0; j < ((FastVector)this.m_Ls.elementAt(i)).size(); ++j) {
                    text.append(((AprioriItemSet)((FastVector)this.m_Ls.elementAt(i)).elementAt(j)).toString(this.m_instances) + "\n");
                }
            }
            text.append("\nBest rules found:\n\n");
            if (this.m_toStringDelimiters != null) {
                text.append("Number,Premise,Premise Support,Consequence,Consequence Support,Confidence,Lift,Leverage,LeverageT,Conviction\n");
            }
            for (i = 0; i < this.m_allTheRules[0].size(); ++i) {
                String convClose;
                String convOpen;
                String levClose;
                String levInner;
                String levOpen;
                String liftClose;
                String liftOpen;
                String confClose;
                String confOpen;
                String implies;
                String stop;
                String innerDelim;
                String outerDelim;
                if (this.m_toStringDelimiters != null) {
                    outerDelim = this.m_toStringDelimiters.substring(0, 1);
                    innerDelim = this.m_toStringDelimiters.substring(1, 2);
                    stop = outerDelim;
                    implies = outerDelim;
                    confOpen = outerDelim;
                    confClose = "";
                    liftOpen = outerDelim;
                    liftClose = "";
                    levOpen = outerDelim;
                    levInner = outerDelim;
                    levClose = "";
                    convOpen = outerDelim;
                    convClose = "";
                } else {
                    outerDelim = " ";
                    innerDelim = " ";
                    stop = ". ";
                    implies = " ==> ";
                    confOpen = "    " + (this.m_metricType == 0 ? "<" : "") + "conf:(";
                    confClose = ")" + (this.m_metricType == 0 ? ">" : "");
                    liftOpen = (this.m_metricType == 1 ? " <" : "") + " lift:(";
                    liftClose = ")" + (this.m_metricType == 1 ? ">" : "");
                    levOpen = (this.m_metricType == 2 ? " <" : "") + " lev:(";
                    levInner = ") [";
                    levClose = "]" + (this.m_metricType == 2 ? ">" : "");
                    convOpen = (this.m_metricType == 3 ? " <" : "") + " conv:(";
                    convClose = ")" + (this.m_metricType == 3 ? ">" : "");
                }
                char odc = outerDelim.charAt(0);
                char idc = innerDelim.charAt(0);
                String n = Utils.doubleToString((double)i + 1.0, (int)(Math.log(this.m_numRules) / Math.log(10.0) + 1.0), 0);
                String premise = ((AprioriItemSet)this.m_allTheRules[0].elementAt(i)).toString(this.m_instances, odc, idc);
                String consequence = ((AprioriItemSet)this.m_allTheRules[1].elementAt(i)).toString(this.m_instances, odc, idc);
                String confidence = Utils.doubleToString((Double)this.m_allTheRules[2].elementAt(i), 2);
                String lift = Utils.doubleToString((Double)this.m_allTheRules[3].elementAt(i), 2);
                String leverage = Utils.doubleToString((Double)this.m_allTheRules[4].elementAt(i), 2);
                String conviction = Utils.doubleToString((Double)this.m_allTheRules[5].elementAt(i), 2);
                int leverageT = (int)((Double)this.m_allTheRules[4].elementAt(i) * (double)this.m_instances.numInstances());
                text.append(n).append(stop);
                text.append(premise).append(implies).append(consequence);
                text.append(confOpen).append(confidence).append(confClose);
                text.append(liftOpen).append(lift).append(liftClose);
                text.append(levOpen).append(leverage).append(levInner).append(leverageT).append(levClose);
                text.append(convOpen).append(conviction).append(convClose);
                text.append('\n');
            }
        } else {
            int i;
            for (i = 0; i < this.m_Ls.size(); ++i) {
                text.append("\nSize of set of large itemsets L(" + (i + 1) + "): " + ((FastVector)this.m_Ls.elementAt(i)).size() + '\n');
                if (!this.m_outputItemSets) continue;
                text.append("\nLarge Itemsets L(" + (i + 1) + "):\n");
                for (int j = 0; j < ((FastVector)this.m_Ls.elementAt(i)).size(); ++j) {
                    text.append(((ItemSet)((FastVector)this.m_Ls.elementAt(i)).elementAt(j)).toString(this.m_instances) + "\n");
                    text.append(((LabeledItemSet)((FastVector)this.m_Ls.elementAt((int)i)).elementAt((int)j)).m_classLabel + "  ");
                    text.append(((LabeledItemSet)((FastVector)this.m_Ls.elementAt(i)).elementAt(j)).support() + "\n");
                }
            }
            text.append("\nBest rules found:\n\n");
            if (this.m_toStringDelimiters != null) {
                text.append("Number,Premise,Premise Support,Consequence,Consequence Support,Confidence\n");
            }
            for (i = 0; i < this.m_allTheRules[0].size(); ++i) {
                String confClose;
                String confOpen;
                String implies;
                String stop;
                String innerDelim;
                String outerDelim;
                if (this.m_toStringDelimiters != null) {
                    outerDelim = this.m_toStringDelimiters.substring(0, 1);
                    innerDelim = this.m_toStringDelimiters.substring(1, 2);
                    stop = outerDelim;
                    implies = outerDelim;
                    confOpen = outerDelim;
                    confClose = "";
                } else {
                    outerDelim = " ";
                    innerDelim = " ";
                    stop = ". ";
                    implies = " ==> ";
                    confOpen = "    conf:(";
                    confClose = ")";
                }
                char odc = outerDelim.charAt(0);
                char idc = innerDelim.charAt(0);
                String n = Utils.doubleToString((double)i + 1.0, (int)(Math.log(this.m_numRules) / Math.log(10.0) + 1.0), 0);
                String premise = ((ItemSet)this.m_allTheRules[0].elementAt(i)).toString(this.m_instances, odc, idc);
                String consequence = ((ItemSet)this.m_allTheRules[1].elementAt(i)).toString(this.m_onlyClass, odc, idc);
                String confidence = Utils.doubleToString((Double)this.m_allTheRules[2].elementAt(i), 2);
                text.append(n).append(stop).append(premise).append(implies).append(consequence).append(confOpen).append(confidence).append(confClose);
                text.append('\n');
            }
        }
        return text.toString();
    }

    @Override
    public String metricString() {
        switch (this.m_metricType) {
            case 1: {
                return "lif";
            }
            case 2: {
                return "leverage";
            }
            case 3: {
                return "conviction";
            }
        }
        return "conf";
    }

    public String removeAllMissingColsTipText() {
        return "Remove columns with all missing values.";
    }

    public void setRemoveAllMissingCols(boolean r) {
        this.m_removeMissingCols = r;
    }

    public boolean getRemoveAllMissingCols() {
        return this.m_removeMissingCols;
    }

    public String upperBoundMinSupportTipText() {
        return "Upper bound for minimum support. Start iteratively decreasing minimum support from this value.";
    }

    public double getUpperBoundMinSupport() {
        return this.m_upperBoundMinSupport;
    }

    public void setUpperBoundMinSupport(double v) {
        this.m_upperBoundMinSupport = v;
    }

    @Override
    public void setClassIndex(int index) {
        this.m_classIndex = index;
    }

    public int getClassIndex() {
        return this.m_classIndex;
    }

    public String classIndexTipText() {
        return "Index of the class attribute. If set to -1, the last attribute is taken as class attribute.";
    }

    public void setCar(boolean flag) {
        this.m_car = flag;
    }

    public boolean getCar() {
        return this.m_car;
    }

    public String carTipText() {
        return "If enabled class association rules are mined instead of (general) association rules.";
    }

    public String lowerBoundMinSupportTipText() {
        return "Lower bound for minimum support.";
    }

    public double getLowerBoundMinSupport() {
        return this.m_lowerBoundMinSupport;
    }

    public void setLowerBoundMinSupport(double v) {
        this.m_lowerBoundMinSupport = v;
    }

    public SelectedTag getMetricType() {
        return new SelectedTag(this.m_metricType, TAGS_SELECTION);
    }

    public String metricTypeTipText() {
        return "Set the type of metric by which to rank rules. Confidence is the proportion of the examples covered by the premise that are also covered by the consequence (Class association rules can only be mined using confidence). Lift is confidence divided by the proportion of all examples that are covered by the consequence. This is a measure of the importance of the association that is independent of support. Leverage is the proportion of additional examples covered by both the premise and consequence above those expected if the premise and consequence were independent of each other. The total number of examples that this represents is presented in brackets following the leverage. Conviction is another measure of departure from independence. Conviction is given by P(premise)P(!consequence) / P(premise, !consequence).";
    }

    public void setMetricType(SelectedTag d) {
        if (d.getTags() == TAGS_SELECTION) {
            this.m_metricType = d.getSelectedTag().getID();
        }
        if (this.m_metricType == 0) {
            this.setMinMetric(0.9);
        }
        if (this.m_metricType == 1 || this.m_metricType == 3) {
            this.setMinMetric(1.1);
        }
        if (this.m_metricType == 2) {
            this.setMinMetric(0.1);
        }
    }

    public String minMetricTipText() {
        return "Minimum metric score. Consider only rules with scores higher than this value.";
    }

    public double getMinMetric() {
        return this.m_minMetric;
    }

    public void setMinMetric(double v) {
        this.m_minMetric = v;
    }

    public String numRulesTipText() {
        return "Number of rules to find.";
    }

    public int getNumRules() {
        return this.m_numRules;
    }

    public void setNumRules(int v) {
        this.m_numRules = v;
    }

    public String deltaTipText() {
        return "Iteratively decrease support by this factor. Reduces support until min support is reached or required number of rules has been generated.";
    }

    public double getDelta() {
        return this.m_delta;
    }

    public void setDelta(double v) {
        this.m_delta = v;
    }

    public String significanceLevelTipText() {
        return "Significance level. Significance test (confidence metric only).";
    }

    public double getSignificanceLevel() {
        return this.m_significanceLevel;
    }

    public void setSignificanceLevel(double v) {
        this.m_significanceLevel = v;
    }

    public void setOutputItemSets(boolean flag) {
        this.m_outputItemSets = flag;
    }

    public boolean getOutputItemSets() {
        return this.m_outputItemSets;
    }

    public String outputItemSetsTipText() {
        return "If enabled the itemsets are output as well.";
    }

    public void setVerbose(boolean flag) {
        this.m_verbose = flag;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public String verboseTipText() {
        return "If enabled the algorithm will be run in verbose mode.";
    }

    public String treatZeroAsMissingTipText() {
        return "If enabled, zero (that is, the first value of a nominal) is treated in the same way as a missing value.";
    }

    public void setTreatZeroAsMissing(boolean z) {
        this.m_treatZeroAsMissing = z;
    }

    public boolean getTreatZeroAsMissing() {
        return this.m_treatZeroAsMissing;
    }

    private void findLargeItemSets() throws Exception {
        int i = 0;
        int necSupport = (int)(this.m_minSupport * (double)this.m_instances.numInstances() + 0.5);
        int necMaxSupport = (int)(this.m_upperBoundMinSupport * (double)this.m_instances.numInstances() + 0.5);
        FastVector kSets = AprioriItemSet.singletons(this.m_instances, this.m_treatZeroAsMissing);
        AprioriItemSet.upDateCounters(kSets, this.m_instances);
        kSets = AprioriItemSet.deleteItemSets(kSets, necSupport, this.m_instances.numInstances());
        if (kSets.size() == 0) {
            return;
        }
        do {
            this.m_Ls.addElement(kSets);
            FastVector kMinusOneSets = kSets;
            kSets = AprioriItemSet.mergeAllItemSets(kMinusOneSets, i, this.m_instances.numInstances());
            Hashtable hashtable = AprioriItemSet.getHashtable(kMinusOneSets, kMinusOneSets.size());
            this.m_hashtables.addElement(hashtable);
            kSets = AprioriItemSet.pruneItemSets(kSets, hashtable);
            AprioriItemSet.upDateCounters(kSets, this.m_instances);
            kSets = AprioriItemSet.deleteItemSets(kSets, necSupport, this.m_instances.numInstances());
            ++i;
        } while (kSets.size() > 0);
    }

    private void findRulesBruteForce() throws Exception {
        for (int j = 1; j < this.m_Ls.size(); ++j) {
            FastVector currentItemSets = (FastVector)this.m_Ls.elementAt(j);
            Enumeration enumItemSets = currentItemSets.elements();
            while (enumItemSets.hasMoreElements()) {
                AprioriItemSet currentItemSet = (AprioriItemSet)enumItemSets.nextElement();
                FastVector[] rules = currentItemSet.generateRulesBruteForce(this.m_minMetric, this.m_metricType, this.m_hashtables, j + 1, this.m_instances.numInstances(), this.m_significanceLevel);
                for (int k = 0; k < rules[0].size(); ++k) {
                    this.m_allTheRules[0].addElement(rules[0].elementAt(k));
                    this.m_allTheRules[1].addElement(rules[1].elementAt(k));
                    this.m_allTheRules[2].addElement(rules[2].elementAt(k));
                    this.m_allTheRules[3].addElement(rules[3].elementAt(k));
                    this.m_allTheRules[4].addElement(rules[4].elementAt(k));
                    this.m_allTheRules[5].addElement(rules[5].elementAt(k));
                }
            }
        }
    }

    private void findRulesQuickly() throws Exception {
        for (int j = 1; j < this.m_Ls.size(); ++j) {
            FastVector currentItemSets = (FastVector)this.m_Ls.elementAt(j);
            Enumeration enumItemSets = currentItemSets.elements();
            while (enumItemSets.hasMoreElements()) {
                AprioriItemSet currentItemSet = (AprioriItemSet)enumItemSets.nextElement();
                FastVector[] rules = currentItemSet.generateRules(this.m_minMetric, this.m_hashtables, j + 1);
                for (int k = 0; k < rules[0].size(); ++k) {
                    this.m_allTheRules[0].addElement(rules[0].elementAt(k));
                    this.m_allTheRules[1].addElement(rules[1].elementAt(k));
                    this.m_allTheRules[2].addElement(rules[2].elementAt(k));
                    if (rules.length <= 3) continue;
                    this.m_allTheRules[3].addElement(rules[3].elementAt(k));
                    this.m_allTheRules[4].addElement(rules[4].elementAt(k));
                    this.m_allTheRules[5].addElement(rules[5].elementAt(k));
                }
            }
        }
    }

    private void findLargeCarItemSets() throws Exception {
        int i = 0;
        double nextMinSupport = this.m_minSupport * (double)this.m_instances.numInstances();
        double nextMaxSupport = this.m_upperBoundMinSupport * (double)this.m_instances.numInstances();
        int necSupport = Math.rint(nextMinSupport) == nextMinSupport ? (int)nextMinSupport : Math.round((float)(nextMinSupport + 0.5));
        int necMaxSupport = Math.rint(nextMaxSupport) == nextMaxSupport ? (int)nextMaxSupport : Math.round((float)(nextMaxSupport + 0.5));
        FastVector kSets = LabeledItemSet.singletons(this.m_instances, this.m_onlyClass);
        LabeledItemSet.upDateCounters(kSets, this.m_instances, this.m_onlyClass);
        kSets = LabeledItemSet.deleteItemSets(kSets, necSupport, this.m_instances.numInstances());
        if (kSets.size() == 0) {
            return;
        }
        do {
            this.m_Ls.addElement(kSets);
            FastVector kMinusOneSets = kSets;
            kSets = LabeledItemSet.mergeAllItemSets(kMinusOneSets, i, this.m_instances.numInstances());
            Hashtable hashtable = LabeledItemSet.getHashtable(kMinusOneSets, kMinusOneSets.size());
            kSets = LabeledItemSet.pruneItemSets(kSets, hashtable);
            LabeledItemSet.upDateCounters(kSets, this.m_instances, this.m_onlyClass);
            kSets = LabeledItemSet.deleteItemSets(kSets, necSupport, this.m_instances.numInstances());
            ++i;
        } while (kSets.size() > 0);
    }

    private void findCarRulesQuickly() throws Exception {
        for (int j = 0; j < this.m_Ls.size(); ++j) {
            FastVector currentLabeledItemSets = (FastVector)this.m_Ls.elementAt(j);
            Enumeration enumLabeledItemSets = currentLabeledItemSets.elements();
            while (enumLabeledItemSets.hasMoreElements()) {
                LabeledItemSet currentLabeledItemSet = (LabeledItemSet)enumLabeledItemSets.nextElement();
                FastVector[] rules = currentLabeledItemSet.generateRules(this.m_minMetric, false);
                for (int k = 0; k < rules[0].size(); ++k) {
                    this.m_allTheRules[0].addElement(rules[0].elementAt(k));
                    this.m_allTheRules[1].addElement(rules[1].elementAt(k));
                    this.m_allTheRules[2].addElement(rules[2].elementAt(k));
                }
            }
        }
    }

    public FastVector[] getAllTheRules() {
        return this.m_allTheRules;
    }

    @Override
    public AssociationRules getAssociationRules() {
        ArrayList<AssociationRule> rules = new ArrayList<AssociationRule>();
        if (this.m_allTheRules != null && this.m_allTheRules.length > 3) {
            for (int i = 0; i < this.m_allTheRules[0].size(); ++i) {
                ArrayList<Item> premise = new ArrayList<Item>();
                ArrayList<Item> consequence = new ArrayList<Item>();
                AprioriItemSet premiseSet = (AprioriItemSet)this.m_allTheRules[0].get(i);
                AprioriItemSet consequenceSet = (AprioriItemSet)this.m_allTheRules[1].get(i);
                for (int j = 0; j < this.m_instances.numAttributes(); ++j) {
                    NominalItem newItem;
                    if (premiseSet.m_items[j] != -1) {
                        try {
                            newItem = new NominalItem(this.m_instances.attribute(j), premiseSet.m_items[j]);
                            premise.add(newItem);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (consequenceSet.m_items[j] == -1) continue;
                    try {
                        newItem = new NominalItem(this.m_instances.attribute(j), consequenceSet.m_items[j]);
                        consequence.add(newItem);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                int totalTrans = premiseSet.m_totalTransactions;
                int totalSupport = consequenceSet.m_counter;
                int premiseSupport = premiseSet.m_counter;
                double lift = (Double)this.m_allTheRules[3].get(i);
                double conf = (Double)this.m_allTheRules[2].get(i);
                int consequenceSupport = (int)((double)totalTrans * conf / lift);
                DefaultAssociationRule.METRIC_TYPE metric = null;
                switch (this.m_metricType) {
                    case 0: {
                        metric = DefaultAssociationRule.METRIC_TYPE.CONFIDENCE;
                        break;
                    }
                    case 1: {
                        metric = DefaultAssociationRule.METRIC_TYPE.LIFT;
                        break;
                    }
                    case 2: {
                        metric = DefaultAssociationRule.METRIC_TYPE.LEVERAGE;
                        break;
                    }
                    case 3: {
                        metric = DefaultAssociationRule.METRIC_TYPE.CONVICTION;
                    }
                }
                DefaultAssociationRule newRule = new DefaultAssociationRule(premise, consequence, metric, premiseSupport, consequenceSupport, totalSupport, totalTrans);
                rules.add(newRule);
            }
        }
        return new AssociationRules(rules, this);
    }

    @Override
    public String[] getRuleMetricNames() {
        String[] metricNames = new String[DefaultAssociationRule.TAGS_SELECTION.length];
        for (int i = 0; i < DefaultAssociationRule.TAGS_SELECTION.length; ++i) {
            metricNames[i] = DefaultAssociationRule.TAGS_SELECTION[i].getReadable();
        }
        return metricNames;
    }

    @Override
    public boolean canProduceRules() {
        return true;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9469 $");
    }

    public static void main(String[] args) {
        Apriori.runAssociator(new Apriori(), args);
    }
}

