/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class CostBenefitAnalysisPanel
extends JPanel {
    private static final long serialVersionUID = 5364871945448769003L;
    protected VisualizePanel m_performancePanel = new VisualizePanel();
    protected VisualizePanel m_costBenefitPanel = new VisualizePanel();
    protected Attribute m_classAttribute;
    protected PlotData2D m_masterPlot;
    protected PlotData2D m_costBenefit;
    protected int[] m_shapeSizes;
    protected int m_previousShapeIndex = -1;
    protected JSlider m_thresholdSlider = new JSlider(0, 100, 0);
    protected JRadioButton m_percPop = new JRadioButton("% of Population");
    protected JRadioButton m_percOfTarget = new JRadioButton("% of Target (recall)");
    protected JRadioButton m_threshold = new JRadioButton("Score Threshold");
    protected JLabel m_percPopLab = new JLabel();
    protected JLabel m_percOfTargetLab = new JLabel();
    protected JLabel m_thresholdLab = new JLabel();
    protected JLabel m_conf_predictedA = new JLabel("Predicted (a)", 4);
    protected JLabel m_conf_predictedB = new JLabel("Predicted (b)", 4);
    protected JLabel m_conf_actualA = new JLabel(" Actual (a):");
    protected JLabel m_conf_actualB = new JLabel(" Actual (b):");
    protected ConfusionCell m_conf_aa = new ConfusionCell();
    protected ConfusionCell m_conf_ab = new ConfusionCell();
    protected ConfusionCell m_conf_ba = new ConfusionCell();
    protected ConfusionCell m_conf_bb = new ConfusionCell();
    protected JLabel m_cost_predictedA = new JLabel("Predicted (a)", 4);
    protected JLabel m_cost_predictedB = new JLabel("Predicted (b)", 4);
    protected JLabel m_cost_actualA = new JLabel(" Actual (a)");
    protected JLabel m_cost_actualB = new JLabel(" Actual (b)");
    protected JTextField m_cost_aa = new JTextField("0.0", 5);
    protected JTextField m_cost_ab = new JTextField("1.0", 5);
    protected JTextField m_cost_ba = new JTextField("1.0", 5);
    protected JTextField m_cost_bb = new JTextField("0.0", 5);
    protected JButton m_maximizeCB = new JButton("Maximize Cost/Benefit");
    protected JButton m_minimizeCB = new JButton("Minimize Cost/Benefit");
    protected JRadioButton m_costR = new JRadioButton("Cost");
    protected JRadioButton m_benefitR = new JRadioButton("Benefit");
    protected JLabel m_costBenefitL = new JLabel("Cost: ", 4);
    protected JLabel m_costBenefitV = new JLabel("0");
    protected JLabel m_randomV = new JLabel("0");
    protected JLabel m_gainV = new JLabel("0");
    protected int m_originalPopSize;
    protected JTextField m_totalPopField = new JTextField(6);
    protected int m_totalPopPrevious;
    protected JLabel m_classificationAccV = new JLabel("-");
    protected double m_tpPrevious;
    protected double m_fpPrevious;
    protected double m_tnPrevious;
    protected double m_fnPrevious;

    public CostBenefitAnalysisPanel() {
        this.setLayout(new BorderLayout());
        this.m_performancePanel.setShowAttBars(false);
        this.m_performancePanel.setShowClassPanel(false);
        this.m_costBenefitPanel.setShowAttBars(false);
        this.m_costBenefitPanel.setShowClassPanel(false);
        Dimension size = new Dimension(500, 400);
        this.m_performancePanel.setPreferredSize(size);
        this.m_performancePanel.setMinimumSize(size);
        size = new Dimension(500, 400);
        this.m_costBenefitPanel.setMinimumSize(size);
        this.m_costBenefitPanel.setPreferredSize(size);
        this.m_thresholdSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CostBenefitAnalysisPanel.this.updateInfoForSliderValue((double)CostBenefitAnalysisPanel.this.m_thresholdSlider.getValue() / 100.0);
            }
        });
        JPanel plotHolder = new JPanel();
        plotHolder.setLayout(new GridLayout(1, 2));
        plotHolder.add(this.m_performancePanel);
        plotHolder.add(this.m_costBenefitPanel);
        this.add((Component)plotHolder, "Center");
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BorderLayout());
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.m_percPop);
        bGroup.add(this.m_percOfTarget);
        bGroup.add(this.m_threshold);
        ButtonGroup bGroup2 = new ButtonGroup();
        bGroup2.add(this.m_costR);
        bGroup2.add(this.m_benefitR);
        ActionListener rl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CostBenefitAnalysisPanel.this.m_costR.isSelected()) {
                    CostBenefitAnalysisPanel.this.m_costBenefitL.setText("Cost: ");
                } else {
                    CostBenefitAnalysisPanel.this.m_costBenefitL.setText("Benefit: ");
                }
                double gain = Double.parseDouble(CostBenefitAnalysisPanel.this.m_gainV.getText());
                gain = -gain;
                CostBenefitAnalysisPanel.this.m_gainV.setText(Utils.doubleToString(gain, 2));
            }
        };
        this.m_costR.addActionListener(rl);
        this.m_benefitR.addActionListener(rl);
        this.m_costR.setSelected(true);
        this.m_percPop.setSelected(true);
        JPanel threshPanel = new JPanel();
        threshPanel.setLayout(new BorderLayout());
        JPanel radioHolder = new JPanel();
        radioHolder.setLayout(new FlowLayout());
        radioHolder.add(this.m_percPop);
        radioHolder.add(this.m_percOfTarget);
        radioHolder.add(this.m_threshold);
        threshPanel.add((Component)radioHolder, "North");
        threshPanel.add((Component)this.m_thresholdSlider, "South");
        JPanel threshInfoPanel = new JPanel();
        threshInfoPanel.setLayout(new GridLayout(3, 2));
        threshInfoPanel.add(new JLabel("% of Population: ", 4));
        threshInfoPanel.add(this.m_percPopLab);
        threshInfoPanel.add(new JLabel("% of Target: ", 4));
        threshInfoPanel.add(this.m_percOfTargetLab);
        threshInfoPanel.add(new JLabel("Score Threshold: ", 4));
        threshInfoPanel.add(this.m_thresholdLab);
        JPanel threshHolder = new JPanel();
        threshHolder.setBorder(BorderFactory.createTitledBorder("Threshold"));
        threshHolder.setLayout(new BorderLayout());
        threshHolder.add((Component)threshPanel, "Center");
        threshHolder.add((Component)threshInfoPanel, "East");
        lowerPanel.add((Component)threshHolder, "North");
        JPanel matrixHolder = new JPanel();
        matrixHolder.setLayout(new GridLayout(1, 2));
        JPanel confusionPanel = new JPanel();
        confusionPanel.setLayout(new GridLayout(3, 3));
        confusionPanel.add(this.m_conf_predictedA);
        confusionPanel.add(this.m_conf_predictedB);
        confusionPanel.add(new JLabel());
        confusionPanel.add(this.m_conf_aa);
        confusionPanel.add(this.m_conf_ab);
        confusionPanel.add(this.m_conf_actualA);
        confusionPanel.add(this.m_conf_ba);
        confusionPanel.add(this.m_conf_bb);
        confusionPanel.add(this.m_conf_actualB);
        JPanel tempHolderCA = new JPanel();
        tempHolderCA.setLayout(new BorderLayout());
        tempHolderCA.setBorder(BorderFactory.createTitledBorder("Confusion Matrix"));
        tempHolderCA.add((Component)confusionPanel, "Center");
        JPanel accHolder = new JPanel();
        accHolder.setLayout(new FlowLayout(0));
        accHolder.add(new JLabel("Classification Accuracy: "));
        accHolder.add(this.m_classificationAccV);
        tempHolderCA.add((Component)accHolder, "South");
        matrixHolder.add(tempHolderCA);
        JPanel costPanel = new JPanel();
        costPanel.setBorder(BorderFactory.createTitledBorder("Cost Matrix"));
        costPanel.setLayout(new BorderLayout());
        JPanel cmHolder = new JPanel();
        cmHolder.setLayout(new GridLayout(3, 3));
        cmHolder.add(this.m_cost_predictedA);
        cmHolder.add(this.m_cost_predictedB);
        cmHolder.add(new JLabel());
        cmHolder.add(this.m_cost_aa);
        cmHolder.add(this.m_cost_ab);
        cmHolder.add(this.m_cost_actualA);
        cmHolder.add(this.m_cost_ba);
        cmHolder.add(this.m_cost_bb);
        cmHolder.add(this.m_cost_actualB);
        costPanel.add((Component)cmHolder, "Center");
        FocusListener fl = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (CostBenefitAnalysisPanel.this.constructCostBenefitData()) {
                    try {
                        CostBenefitAnalysisPanel.this.m_costBenefitPanel.setMasterPlot(CostBenefitAnalysisPanel.this.m_costBenefit);
                        CostBenefitAnalysisPanel.this.m_costBenefitPanel.validate();
                        CostBenefitAnalysisPanel.this.m_costBenefitPanel.repaint();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    CostBenefitAnalysisPanel.this.updateCostBenefit();
                }
            }
        };
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CostBenefitAnalysisPanel.this.constructCostBenefitData()) {
                    try {
                        CostBenefitAnalysisPanel.this.m_costBenefitPanel.setMasterPlot(CostBenefitAnalysisPanel.this.m_costBenefit);
                        CostBenefitAnalysisPanel.this.m_costBenefitPanel.validate();
                        CostBenefitAnalysisPanel.this.m_costBenefitPanel.repaint();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    CostBenefitAnalysisPanel.this.updateCostBenefit();
                }
            }
        };
        this.m_cost_aa.addFocusListener(fl);
        this.m_cost_aa.addActionListener(al);
        this.m_cost_ab.addFocusListener(fl);
        this.m_cost_ab.addActionListener(al);
        this.m_cost_ba.addFocusListener(fl);
        this.m_cost_ba.addActionListener(al);
        this.m_cost_bb.addFocusListener(fl);
        this.m_cost_bb.addActionListener(al);
        this.m_totalPopField.addFocusListener(fl);
        this.m_totalPopField.addActionListener(al);
        JPanel cbHolder = new JPanel();
        cbHolder.setLayout(new BorderLayout());
        JPanel tempP = new JPanel();
        tempP.setLayout(new GridLayout(3, 2));
        tempP.add(this.m_costBenefitL);
        tempP.add(this.m_costBenefitV);
        tempP.add(new JLabel("Random: ", 4));
        tempP.add(this.m_randomV);
        tempP.add(new JLabel("Gain: ", 4));
        tempP.add(this.m_gainV);
        cbHolder.add((Component)tempP, "North");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(2, 1));
        butHolder.add(this.m_maximizeCB);
        butHolder.add(this.m_minimizeCB);
        this.m_maximizeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CostBenefitAnalysisPanel.this.findMaxMinCB(true);
            }
        });
        this.m_minimizeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CostBenefitAnalysisPanel.this.findMaxMinCB(false);
            }
        });
        cbHolder.add((Component)butHolder, "South");
        costPanel.add((Component)cbHolder, "East");
        JPanel popCBR = new JPanel();
        popCBR.setLayout(new GridLayout(1, 2));
        JPanel popHolder = new JPanel();
        popHolder.setLayout(new FlowLayout(0));
        popHolder.add(new JLabel("Total Population: "));
        popHolder.add(this.m_totalPopField);
        JPanel radioHolder2 = new JPanel();
        radioHolder2.setLayout(new FlowLayout(2));
        radioHolder2.add(this.m_costR);
        radioHolder2.add(this.m_benefitR);
        popCBR.add(popHolder);
        popCBR.add(radioHolder2);
        costPanel.add((Component)popCBR, "South");
        matrixHolder.add(costPanel);
        lowerPanel.add((Component)matrixHolder, "South");
        this.add((Component)lowerPanel, "South");
    }

    public PlotData2D getMasterPlot() {
        return this.m_masterPlot;
    }

    private void findMaxMinCB(boolean max) {
        double maxMin = max ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        Instances cBCurve = this.m_costBenefit.getPlotInstances();
        int maxMinIndex = 0;
        for (int i = 0; i < cBCurve.numInstances(); ++i) {
            Instance current = cBCurve.instance(i);
            if (max) {
                if (!(current.value(1) > maxMin)) continue;
                maxMin = current.value(1);
                maxMinIndex = i;
                continue;
            }
            if (!(current.value(1) < maxMin)) continue;
            maxMin = current.value(1);
            maxMinIndex = i;
        }
        int indexOfSampleSize = this.m_masterPlot.getPlotInstances().attribute("Sample Size").index();
        int indexOfPercOfTarget = this.m_masterPlot.getPlotInstances().attribute("Recall").index();
        int indexOfThreshold = this.m_masterPlot.getPlotInstances().attribute("Threshold").index();
        int indexOfMetric = this.m_percPop.isSelected() ? indexOfSampleSize : (this.m_percOfTarget.isSelected() ? indexOfPercOfTarget : indexOfThreshold);
        double valueOfMetric = this.m_masterPlot.getPlotInstances().instance(maxMinIndex).value(indexOfMetric);
        this.m_thresholdSlider.setValue((int)(valueOfMetric *= 100.0));
        this.updateInfoGivenIndex(maxMinIndex);
    }

    private void updateCostBenefit() {
        double value = (double)this.m_thresholdSlider.getValue() / 100.0;
        Instances plotInstances = this.m_masterPlot.getPlotInstances();
        int indexOfSampleSize = this.m_masterPlot.getPlotInstances().attribute("Sample Size").index();
        int indexOfPercOfTarget = this.m_masterPlot.getPlotInstances().attribute("Recall").index();
        int indexOfThreshold = this.m_masterPlot.getPlotInstances().attribute("Threshold").index();
        int indexOfMetric = this.m_percPop.isSelected() ? indexOfSampleSize : (this.m_percOfTarget.isSelected() ? indexOfPercOfTarget : indexOfThreshold);
        int index = this.findIndexForValue(value, plotInstances, indexOfMetric);
        this.updateCBRandomGainInfo(index);
    }

    private void updateCBRandomGainInfo(int index) {
        double requestedPopSize = this.m_originalPopSize;
        try {
            requestedPopSize = Double.parseDouble(this.m_totalPopField.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        double scaleFactor = requestedPopSize / (double)this.m_originalPopSize;
        double CB = this.m_costBenefit.getPlotInstances().instance(index).value(1);
        this.m_costBenefitV.setText(Utils.doubleToString(CB, 2));
        double totalRandomCB = 0.0;
        Instance first = this.m_masterPlot.getPlotInstances().instance(0);
        double totalPos = first.value(this.m_masterPlot.getPlotInstances().attribute("True Positives").index()) * scaleFactor;
        double totalNeg = first.value(this.m_masterPlot.getPlotInstances().attribute("False Positives")) * scaleFactor;
        double posInSample = totalPos * (Double.parseDouble(this.m_percPopLab.getText()) / 100.0);
        double negInSample = totalNeg * (Double.parseDouble(this.m_percPopLab.getText()) / 100.0);
        double posOutSample = totalPos - posInSample;
        double negOutSample = totalNeg - negInSample;
        double tpCost = 0.0;
        try {
            tpCost = Double.parseDouble(this.m_cost_aa.getText());
        }
        catch (NumberFormatException n) {
            // empty catch block
        }
        double fpCost = 0.0;
        try {
            fpCost = Double.parseDouble(this.m_cost_ba.getText());
        }
        catch (NumberFormatException n) {
            // empty catch block
        }
        double tnCost = 0.0;
        try {
            tnCost = Double.parseDouble(this.m_cost_bb.getText());
        }
        catch (NumberFormatException n) {
            // empty catch block
        }
        double fnCost = 0.0;
        try {
            fnCost = Double.parseDouble(this.m_cost_ab.getText());
        }
        catch (NumberFormatException n) {
            // empty catch block
        }
        totalRandomCB += posInSample * tpCost;
        totalRandomCB += negInSample * fpCost;
        totalRandomCB += posOutSample * fnCost;
        this.m_randomV.setText(Utils.doubleToString(totalRandomCB += negOutSample * tnCost, 2));
        double gain = this.m_costR.isSelected() ? totalRandomCB - CB : CB - totalRandomCB;
        this.m_gainV.setText(Utils.doubleToString(gain, 2));
        Instance currentInst = this.m_masterPlot.getPlotInstances().instance(index);
        double tp = currentInst.value(this.m_masterPlot.getPlotInstances().attribute("True Positives").index());
        double tn = currentInst.value(this.m_masterPlot.getPlotInstances().attribute("True Negatives").index());
        this.m_classificationAccV.setText(Utils.doubleToString((tp + tn) / (totalPos + totalNeg) * 100.0, 4) + "%");
    }

    private void updateInfoGivenIndex(int index) {
        double totalInstances;
        Instances plotInstances = this.m_masterPlot.getPlotInstances();
        int indexOfSampleSize = this.m_masterPlot.getPlotInstances().attribute("Sample Size").index();
        int indexOfPercOfTarget = this.m_masterPlot.getPlotInstances().attribute("Recall").index();
        int indexOfThreshold = this.m_masterPlot.getPlotInstances().attribute("Threshold").index();
        this.m_percPopLab.setText(Utils.doubleToString(100.0 * plotInstances.instance(index).value(indexOfSampleSize), 4));
        this.m_percOfTargetLab.setText(Utils.doubleToString(100.0 * plotInstances.instance(index).value(indexOfPercOfTarget), 4));
        this.m_thresholdLab.setText(Utils.doubleToString(plotInstances.instance(index).value(indexOfThreshold), 4));
        if (this.m_previousShapeIndex >= 0) {
            this.m_shapeSizes[this.m_previousShapeIndex] = 1;
        }
        this.m_shapeSizes[index] = 10;
        this.m_previousShapeIndex = index;
        int tp = plotInstances.attribute("True Positives").index();
        int fp = plotInstances.attribute("False Positives").index();
        int tn = plotInstances.attribute("True Negatives").index();
        int fn = plotInstances.attribute("False Negatives").index();
        Instance temp = plotInstances.instance(index);
        double requestedPopSize = totalInstances = temp.value(tp) + temp.value(fp) + temp.value(tn) + temp.value(fn);
        try {
            requestedPopSize = Double.parseDouble(this.m_totalPopField.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.m_conf_aa.setCellValue(temp.value(tp), totalInstances, requestedPopSize / totalInstances, 2);
        this.m_conf_ab.setCellValue(temp.value(fn), totalInstances, requestedPopSize / totalInstances, 2);
        this.m_conf_ba.setCellValue(temp.value(fp), totalInstances, requestedPopSize / totalInstances, 2);
        this.m_conf_bb.setCellValue(temp.value(tn), totalInstances, requestedPopSize / totalInstances, 2);
        this.updateCBRandomGainInfo(index);
        this.repaint();
    }

    private void updateInfoForSliderValue(double value) {
        int indexOfSampleSize = this.m_masterPlot.getPlotInstances().attribute("Sample Size").index();
        int indexOfPercOfTarget = this.m_masterPlot.getPlotInstances().attribute("Recall").index();
        int indexOfThreshold = this.m_masterPlot.getPlotInstances().attribute("Threshold").index();
        int indexOfMetric = this.m_percPop.isSelected() ? indexOfSampleSize : (this.m_percOfTarget.isSelected() ? indexOfPercOfTarget : indexOfThreshold);
        Instances plotInstances = this.m_masterPlot.getPlotInstances();
        int index = this.findIndexForValue(value, plotInstances, indexOfMetric);
        this.updateInfoGivenIndex(index);
    }

    private int findIndexForValue(double value, Instances plotInstances, int indexOfMetric) {
        int index = -1;
        int lower = 0;
        int upper = plotInstances.numInstances() - 1;
        int mid = (upper - lower) / 2;
        boolean done = false;
        while (!done) {
            if (upper - lower <= 1) {
                double comp1 = plotInstances.instance(upper).value(indexOfMetric);
                double comp2 = plotInstances.instance(lower).value(indexOfMetric);
                if (Math.abs(comp1 - value) < Math.abs(comp2 - value)) {
                    index = upper;
                    break;
                }
                index = lower;
                break;
            }
            double comparisonVal = plotInstances.instance(mid).value(indexOfMetric);
            if (value > comparisonVal) {
                if (this.m_threshold.isSelected()) {
                    lower = mid;
                    mid += (upper - lower) / 2;
                    continue;
                }
                upper = mid;
                mid -= (upper - lower) / 2;
                continue;
            }
            if (value < comparisonVal) {
                if (this.m_threshold.isSelected()) {
                    upper = mid;
                    mid -= (upper - lower) / 2;
                    continue;
                }
                lower = mid;
                mid += (upper - lower) / 2;
                continue;
            }
            index = mid;
            done = true;
        }
        if (!this.m_threshold.isSelected()) {
            while (index + 1 < plotInstances.numInstances() && plotInstances.instance(index + 1).value(indexOfMetric) == plotInstances.instance(index).value(indexOfMetric)) {
                ++index;
            }
        } else {
            while (index - 1 >= 0 && plotInstances.instance(index - 1).value(indexOfMetric) == plotInstances.instance(index).value(indexOfMetric)) {
                --index;
            }
        }
        return index;
    }

    public synchronized void setDataSet(PlotData2D data, Attribute classAtt) throws Exception {
        int i;
        this.m_masterPlot = new PlotData2D(data.getPlotInstances());
        boolean[] connectPoints = new boolean[this.m_masterPlot.getPlotInstances().numInstances()];
        for (i = 1; i < connectPoints.length; ++i) {
            connectPoints[i] = true;
        }
        this.m_masterPlot.setConnectPoints(connectPoints);
        this.m_masterPlot.m_alwaysDisplayPointsOfThisSize = 10;
        this.setClassForConfusionMatrix(classAtt);
        this.m_performancePanel.setMasterPlot(this.m_masterPlot);
        this.m_performancePanel.validate();
        this.m_performancePanel.repaint();
        this.m_shapeSizes = new int[this.m_masterPlot.getPlotInstances().numInstances()];
        for (i = 0; i < this.m_shapeSizes.length; ++i) {
            this.m_shapeSizes[i] = 1;
        }
        this.m_masterPlot.setShapeSize(this.m_shapeSizes);
        this.constructCostBenefitData();
        this.m_costBenefitPanel.setMasterPlot(this.m_costBenefit);
        this.m_costBenefitPanel.validate();
        this.m_costBenefitPanel.repaint();
        this.m_totalPopPrevious = 0;
        this.m_fpPrevious = 0.0;
        this.m_tpPrevious = 0.0;
        this.m_tnPrevious = 0.0;
        this.m_fnPrevious = 0.0;
        this.m_previousShapeIndex = -1;
        Instance first = this.m_masterPlot.getPlotInstances().instance(0);
        double totalPos = first.value(this.m_masterPlot.getPlotInstances().attribute("True Positives").index());
        double totalNeg = first.value(this.m_masterPlot.getPlotInstances().attribute("False Positives"));
        this.m_originalPopSize = (int)(totalPos + totalNeg);
        this.m_totalPopField.setText("" + this.m_originalPopSize);
        this.m_performancePanel.setYIndex(5);
        this.m_performancePanel.setXIndex(10);
        this.m_costBenefitPanel.setXIndex(0);
        this.m_costBenefitPanel.setYIndex(1);
        this.updateInfoForSliderValue((double)this.m_thresholdSlider.getValue() / 100.0);
    }

    private void setClassForConfusionMatrix(Attribute classAtt) {
        this.m_classAttribute = classAtt;
        this.m_conf_actualA.setText(" Actual (a): " + classAtt.value(0));
        this.m_conf_actualA.setToolTipText(classAtt.value(0));
        String negClasses = "";
        for (int i = 1; i < classAtt.numValues(); ++i) {
            negClasses = negClasses + classAtt.value(i);
            if (i >= classAtt.numValues() - 1) continue;
            negClasses = negClasses + ",";
        }
        this.m_conf_actualB.setText(" Actual (b): " + negClasses);
        this.m_conf_actualB.setToolTipText(negClasses);
    }

    private boolean constructCostBenefitData() {
        double tpCost = 0.0;
        try {
            tpCost = Double.parseDouble(this.m_cost_aa.getText());
        }
        catch (NumberFormatException n) {
            // empty catch block
        }
        double fpCost = 0.0;
        try {
            fpCost = Double.parseDouble(this.m_cost_ba.getText());
        }
        catch (NumberFormatException n) {
            // empty catch block
        }
        double tnCost = 0.0;
        try {
            tnCost = Double.parseDouble(this.m_cost_bb.getText());
        }
        catch (NumberFormatException n) {
            // empty catch block
        }
        double fnCost = 0.0;
        try {
            fnCost = Double.parseDouble(this.m_cost_ab.getText());
        }
        catch (NumberFormatException n) {
            // empty catch block
        }
        double requestedPopSize = this.m_originalPopSize;
        try {
            requestedPopSize = Double.parseDouble(this.m_totalPopField.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        double scaleFactor = 1.0;
        if (this.m_originalPopSize != 0) {
            scaleFactor = requestedPopSize / (double)this.m_originalPopSize;
        }
        if (tpCost == this.m_tpPrevious && fpCost == this.m_fpPrevious && tnCost == this.m_tnPrevious && fnCost == this.m_fnPrevious && requestedPopSize == (double)this.m_totalPopPrevious) {
            return false;
        }
        ArrayList<Attribute> fv = new ArrayList<Attribute>();
        fv.add(new Attribute("Sample Size"));
        fv.add(new Attribute("Cost/Benefit"));
        fv.add(new Attribute("Threshold"));
        Instances costBenefitI = new Instances("Cost/Benefit Curve", fv, 100);
        Instances performanceI = this.m_masterPlot.getPlotInstances();
        for (int i = 0; i < performanceI.numInstances(); ++i) {
            Instance current = performanceI.instance(i);
            double[] vals = new double[]{current.value(10), (current.value(0) * tpCost + current.value(1) * fnCost + current.value(2) * fpCost + current.value(3) * tnCost) * scaleFactor, current.value(current.numAttributes() - 1)};
            DenseInstance newInst = new DenseInstance(1.0, vals);
            costBenefitI.add(newInst);
        }
        costBenefitI.compactify();
        this.m_costBenefit = new PlotData2D(costBenefitI);
        this.m_costBenefit.m_alwaysDisplayPointsOfThisSize = 10;
        this.m_costBenefit.setPlotName("Cost/benefit curve");
        boolean[] connectPoints = new boolean[costBenefitI.numInstances()];
        for (int i = 0; i < connectPoints.length; ++i) {
            connectPoints[i] = true;
        }
        try {
            this.m_costBenefit.setConnectPoints(connectPoints);
            this.m_costBenefit.setShapeSize(this.m_shapeSizes);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.m_tpPrevious = tpCost;
        this.m_fpPrevious = fpCost;
        this.m_tnPrevious = tnCost;
        this.m_fnPrevious = fnCost;
        return true;
    }

    protected static class ConfusionCell
    extends JPanel {
        private static final long serialVersionUID = 6148640235434494767L;
        private final JLabel m_conf_cell = new JLabel("-", 4);
        JLabel m_conf_perc = new JLabel("-", 4);
        private final JPanel m_percentageP;
        protected double m_percentage = 0.0;

        public ConfusionCell() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEtchedBorder());
            this.add((Component)this.m_conf_cell, "North");
            this.m_percentageP = new JPanel(){

                @Override
                public void paintComponent(Graphics gx) {
                    super.paintComponent(gx);
                    if (ConfusionCell.this.m_percentage > 0.0) {
                        gx.setColor(Color.BLUE);
                        int height = this.getHeight();
                        double width = this.getWidth();
                        int barWidth = (int)(ConfusionCell.this.m_percentage * width);
                        gx.fillRect(0, 0, barWidth, height);
                    }
                }
            };
            Dimension d = new Dimension(30, 5);
            this.m_percentageP.setMinimumSize(d);
            this.m_percentageP.setPreferredSize(d);
            JPanel percHolder = new JPanel();
            percHolder.setLayout(new BorderLayout());
            percHolder.add((Component)this.m_percentageP, "Center");
            percHolder.add((Component)this.m_conf_perc, "East");
            this.add((Component)percHolder, "South");
        }

        public void setCellValue(double cellValue, double max, double scaleFactor, int precision) {
            this.m_percentage = !Utils.isMissingValue(cellValue) ? cellValue / max : 0.0;
            this.m_conf_cell.setText(Utils.doubleToString(cellValue * scaleFactor, 0));
            this.m_conf_perc.setText(Utils.doubleToString(this.m_percentage * 100.0, precision) + "%");
            this.m_percentageP.repaint();
        }
    }
}

