/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.net.URL;
import java.util.List;

public class SplashWindow
extends Window {
    private static final long serialVersionUID = -2685134277041307795L;
    private static SplashWindow m_instance;
    private final Image image;
    private final List<String> message;
    private boolean paintCalled = false;

    private SplashWindow(Frame parent, Image image, List<String> message) {
        super(parent);
        this.image = image;
        this.message = message;
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        int imgWidth = image.getWidth(this);
        int imgHeight = image.getHeight(this);
        this.setSize(imgWidth, imgHeight);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (ge.getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSLUCENT)) {
            this.setShape(new Ellipse2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        }
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenDim.width - imgWidth) / 2, (screenDim.height - imgHeight) / 2);
        MouseAdapter disposeOnClick = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent evt) {
                SplashWindow splashWindow = SplashWindow.this;
                synchronized (splashWindow) {
                    SplashWindow.this.paintCalled = true;
                    SplashWindow.this.notifyAll();
                }
                SplashWindow.this.dispose();
            }
        };
        this.addMouseListener(disposeOnClick);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    private void paintMessage(Graphics g) {
        int imgWidth = this.image.getWidth(this);
        int imgHeight = this.image.getHeight(this);
        g.setFont(new Font(null, 1, 10));
        g.setColor(Color.WHITE);
        FontMetrics fm = g.getFontMetrics();
        int hf = fm.getAscent() + 1;
        int heightStart = 4 * (imgHeight / 5) + 5;
        int count = 0;
        for (String s : this.message) {
            int textWidth = fm.stringWidth(s);
            g.drawString(s, (imgWidth - textWidth) / 2, heightStart + count * hf);
            ++count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
        if (this.message != null) {
            this.paintMessage(g);
        }
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splash(Image image, List<String> message) {
        if (m_instance == null && image != null) {
            Frame f = new Frame();
            m_instance = new SplashWindow(f, image, message);
            m_instance.show();
            if (!EventQueue.isDispatchThread() && Runtime.getRuntime().availableProcessors() == 1) {
                SplashWindow splashWindow = m_instance;
                synchronized (splashWindow) {
                    while (!SplashWindow.m_instance.paintCalled) {
                        try {
                            m_instance.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                }
            }
        }
    }

    public static void splash(URL imageURL) {
        SplashWindow.splash(imageURL, null);
    }

    public static void splash(URL imageURL, List<String> message) {
        if (imageURL != null) {
            SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(imageURL), message);
        }
    }

    public static void disposeSplash() {
        if (m_instance != null) {
            m_instance.getOwner().dispose();
            m_instance = null;
        }
    }

    public static void invokeMethod(String className, String methodName, String[] args) {
        try {
            Class.forName(className).getMethod(methodName, String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            InternalError error = new InternalError("Failed to invoke method: " + methodName);
            error.initCause(e);
            throw error;
        }
    }

    public static void invokeMain(String className, String[] args) {
        try {
            Class.forName(className).getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            InternalError error = new InternalError("Failed to invoke main method");
            error.initCause(e);
            throw error;
        }
    }
}

