/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.BestFirst;
import weka.attributeSelection.CfsSubsetEval;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.trees.J48;
import weka.core.AdditionalMeasureProducer;
import weka.core.BatchPredictor;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.WekaException;

public class AttributeSelectedClassifier
extends SingleClassifierEnhancer
implements OptionHandler,
Drawable,
AdditionalMeasureProducer,
WeightedInstancesHandler {
    static final long serialVersionUID = -1151805453487947577L;
    protected AttributeSelection m_AttributeSelection = null;
    protected ASEvaluation m_Evaluator = new CfsSubsetEval();
    protected ASSearch m_Search = new BestFirst();
    protected Instances m_ReducedHeader;
    protected int m_numClasses;
    protected double m_numAttributesSelected;
    protected double m_selectionTime;
    protected double m_totalTime;

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public AttributeSelectedClassifier() {
        this.m_Classifier = new J48();
    }

    public String globalInfo() {
        return "Dimensionality of training and test data is reduced by attribute selection before being passed on to a classifier.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tFull class name of attribute evaluator, followed\n\tby its options.\n\teg: \"weka.attributeSelection.CfsSubsetEval -L\"\n\t(default weka.attributeSelection.CfsSubsetEval)", "E", 1, "-E <attribute evaluator specification>"));
        newVector.addElement(new Option("\tFull class name of search method, followed\n\tby its options.\n\teg: \"weka.attributeSelection.BestFirst -D 1\"\n\t(default weka.attributeSelection.BestFirst)", "S", 1, "-S <search method specification>"));
        newVector.addAll(Collections.list(super.listOptions()));
        if (this.getEvaluator() instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to attribute evaluator " + this.getEvaluator().getClass().getName() + ":"));
            newVector.addAll(Collections.list(((OptionHandler)((Object)this.getEvaluator())).listOptions()));
        }
        if (this.getSearch() instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to search method " + this.getSearch().getClass().getName() + ":"));
            newVector.addAll(Collections.list(((OptionHandler)((Object)this.getSearch())).listOptions()));
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String[] searchSpec;
        String[] evaluatorSpec;
        String evaluatorString = Utils.getOption('E', options);
        if (evaluatorString.length() == 0) {
            evaluatorString = CfsSubsetEval.class.getName();
        }
        if ((evaluatorSpec = Utils.splitOptions(evaluatorString)).length == 0) {
            throw new Exception("Invalid attribute evaluator specification string");
        }
        String evaluatorName = evaluatorSpec[0];
        evaluatorSpec[0] = "";
        this.setEvaluator(ASEvaluation.forName(evaluatorName, evaluatorSpec));
        String searchString = Utils.getOption('S', options);
        if (searchString.length() == 0) {
            searchString = BestFirst.class.getName();
        }
        if ((searchSpec = Utils.splitOptions(searchString)).length == 0) {
            throw new Exception("Invalid search specification string");
        }
        String searchName = searchSpec[0];
        searchSpec[0] = "";
        this.setSearch(ASSearch.forName(searchName, searchSpec));
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-E");
        options.add("" + this.getEvaluatorSpec());
        options.add("-S");
        options.add("" + this.getSearchSpec());
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public String evaluatorTipText() {
        return "Set the attribute evaluator to use. This evaluator is used during the attribute selection phase before the classifier is invoked.";
    }

    public void setEvaluator(ASEvaluation evaluator) {
        this.m_Evaluator = evaluator;
    }

    public ASEvaluation getEvaluator() {
        return this.m_Evaluator;
    }

    protected String getEvaluatorSpec() {
        ASEvaluation e = this.getEvaluator();
        if (e instanceof OptionHandler) {
            return e.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)e)).getOptions());
        }
        return e.getClass().getName();
    }

    public String searchTipText() {
        return "Set the search method. This search method is used during the attribute selection phase before the classifier is invoked.";
    }

    public void setSearch(ASSearch search) {
        this.m_Search = search;
    }

    public ASSearch getSearch() {
        return this.m_Search;
    }

    protected String getSearchSpec() {
        ASSearch s = this.getSearch();
        if (s instanceof OptionHandler) {
            return s.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)s)).getOptions());
        }
        return s.getClass().getName();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.getEvaluator() == null ? super.getCapabilities() : this.getEvaluator().getCapabilities();
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.m_Classifier == null) {
            throw new Exception("No base classifier has been set!");
        }
        if (this.m_Evaluator == null) {
            throw new Exception("No attribute evaluator has been set!");
        }
        if (this.m_Search == null) {
            throw new Exception("No search method has been set!");
        }
        this.getCapabilities().testWithFail(data);
        Instances newData = new Instances(data);
        if (newData.numInstances() == 0) {
            this.m_Classifier.buildClassifier(newData);
            return;
        }
        this.m_numClasses = newData.classAttribute().isNominal() ? newData.classAttribute().numValues() : 1;
        Instances resampledData = null;
        double weight = newData.instance(0).weight();
        boolean ok = false;
        for (int i = 1; i < newData.numInstances(); ++i) {
            if (newData.instance(i).weight() == weight) continue;
            ok = true;
            break;
        }
        if (ok) {
            if (!(this.m_Evaluator instanceof WeightedInstancesHandler) || !(this.m_Classifier instanceof WeightedInstancesHandler)) {
                Random r = new Random(1L);
                for (int i = 0; i < 10; ++i) {
                    r.nextDouble();
                }
                resampledData = newData.resampleWithWeights(r);
            }
        } else {
            resampledData = newData;
        }
        this.m_AttributeSelection = new AttributeSelection();
        this.m_AttributeSelection.setEvaluator(this.m_Evaluator);
        this.m_AttributeSelection.setSearch(this.m_Search);
        long start = System.currentTimeMillis();
        this.m_AttributeSelection.SelectAttributes(this.m_Evaluator instanceof WeightedInstancesHandler ? newData : resampledData);
        long end = System.currentTimeMillis();
        if (this.m_Classifier instanceof WeightedInstancesHandler) {
            newData = this.m_AttributeSelection.reduceDimensionality(newData);
            this.m_Classifier.buildClassifier(newData);
        } else {
            resampledData = this.m_AttributeSelection.reduceDimensionality(resampledData);
            this.m_Classifier.buildClassifier(resampledData);
        }
        long end2 = System.currentTimeMillis();
        this.m_numAttributesSelected = this.m_AttributeSelection.numberAttributesSelected();
        this.m_ReducedHeader = new Instances(this.m_Classifier instanceof WeightedInstancesHandler ? newData : resampledData, 0);
        this.m_selectionTime = end - start;
        this.m_totalTime = end2 - start;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        Instance newInstance = this.m_AttributeSelection == null ? instance : this.m_AttributeSelection.reduceDimensionality(instance);
        return this.m_Classifier.distributionForInstance(newInstance);
    }

    @Override
    public String batchSizeTipText() {
        return "Batch size to use if base learner is a BatchPredictor";
    }

    @Override
    public void setBatchSize(String size) {
        if (this.getClassifier() instanceof BatchPredictor) {
            ((BatchPredictor)((Object)this.getClassifier())).setBatchSize(size);
        } else {
            super.setBatchSize(size);
        }
    }

    @Override
    public String getBatchSize() {
        if (this.getClassifier() instanceof BatchPredictor) {
            return ((BatchPredictor)((Object)this.getClassifier())).getBatchSize();
        }
        return super.getBatchSize();
    }

    @Override
    public double[][] distributionsForInstances(Instances insts) throws Exception {
        if (this.getClassifier() instanceof BatchPredictor) {
            Instances newInstances = this.m_AttributeSelection == null ? insts : this.m_AttributeSelection.reduceDimensionality(insts);
            if (newInstances.numInstances() != insts.numInstances()) {
                throw new WekaException("FilteredClassifier: filter has returned more/less instances than required.");
            }
            return ((BatchPredictor)((Object)this.getClassifier())).distributionsForInstances(newInstances);
        }
        double[][] result = new double[insts.numInstances()][insts.numClasses()];
        for (int i = 0; i < insts.numInstances(); ++i) {
            result[i] = this.distributionForInstance(insts.instance(i));
        }
        return result;
    }

    @Override
    public boolean implementsMoreEfficientBatchPrediction() {
        if (!(this.getClassifier() instanceof BatchPredictor)) {
            return super.implementsMoreEfficientBatchPrediction();
        }
        return ((BatchPredictor)((Object)this.getClassifier())).implementsMoreEfficientBatchPrediction();
    }

    @Override
    public int graphType() {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graphType();
        }
        return 0;
    }

    @Override
    public String graph() throws Exception {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graph();
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot be graphed");
    }

    public String toString() {
        if (this.m_AttributeSelection == null) {
            return "AttributeSelectedClassifier: No attribute selection possible.\n\n" + this.m_Classifier.toString();
        }
        StringBuffer result = new StringBuffer();
        result.append("AttributeSelectedClassifier:\n\n");
        result.append(this.m_AttributeSelection.toResultsString());
        result.append("\n\nHeader of reduced data:\n" + this.m_ReducedHeader.toString());
        result.append("\n\nClassifier Model\n" + this.m_Classifier.toString());
        return result.toString();
    }

    public double measureNumAttributesSelected() {
        return this.m_numAttributesSelected;
    }

    public double measureSelectionTime() {
        return this.m_selectionTime;
    }

    public double measureTime() {
        return this.m_totalTime;
    }

    @Override
    public Enumeration<String> enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(3);
        newVector.addElement("measureNumAttributesSelected");
        newVector.addElement("measureSelectionTime");
        newVector.addElement("measureTime");
        if (this.m_Classifier instanceof AdditionalMeasureProducer) {
            newVector.addAll(Collections.list(((AdditionalMeasureProducer)((Object)this.m_Classifier)).enumerateMeasures()));
        }
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureNumAttributesSelected") == 0) {
            return this.measureNumAttributesSelected();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureSelectionTime") == 0) {
            return this.measureSelectionTime();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureTime") == 0) {
            return this.measureTime();
        }
        if (this.m_Classifier instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (AttributeSelectedClassifier)");
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14259 $");
    }

    public static void main(String[] argv) {
        AttributeSelectedClassifier.runClassifier(new AttributeSelectedClassifier(), argv);
    }
}

